/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.HeapSizeManager;
import com.google.cloud.bigtable.hbase.BatchExecutor;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutator;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.cloud.bigtable.hbase.BigtableRegionLocator;
import com.google.cloud.bigtable.hbase.BigtableTable;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Threads;

public abstract class AbstractBigtableConnection
implements Connection,
Closeable {
    public static final String MAX_INFLIGHT_RPCS_KEY = "google.bigtable.buffered.mutator.max.inflight.rpcs";
    public static final String BIGTABLE_BUFFERED_MUTATOR_MAX_MEMORY_KEY = "google.bigtable.buffered.mutator.max.memory";
    private static final AtomicLong SEQUENCE_GENERATOR = new AtomicLong();
    private static final Map<Long, BigtableBufferedMutator> ACTIVE_BUFFERED_MUTATORS = Collections.synchronizedMap(new HashMap());
    private final Logger LOG = new Logger(this.getClass());
    private static final Set<RegionLocator> locatorCache;
    private final Configuration conf;
    private volatile boolean closed = false;
    private volatile boolean aborted;
    private volatile ExecutorService batchPool = null;
    private ExecutorService bufferedMutatorExecutorService;
    private BigtableSession session;
    private volatile boolean cleanupPool = false;
    private final BigtableOptions options;
    private final TableConfiguration tableConfig;
    private Set<TableName> disabledTables = new HashSet<TableName>();

    public AbstractBigtableConnection(Configuration conf) throws IOException {
        this(conf, false, null, null);
    }

    protected AbstractBigtableConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        if (managed) {
            throw new IllegalArgumentException("Bigtable does not support managed connections.");
        }
        this.conf = conf;
        try {
            this.options = BigtableOptionsFactory.fromConfiguration(conf);
        }
        catch (IOException ioe) {
            this.LOG.error("Error loading BigtableOptions from Configuration.", ioe, new Object[0]);
            throw ioe;
        }
        this.batchPool = pool;
        this.closed = false;
        if (this.batchPool == null) {
            this.batchPool = this.getBatchPool();
        }
        this.session = new BigtableSession(this.options, this.batchPool);
        this.tableConfig = new TableConfiguration(conf);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.getBatchPool());
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        BigtableDataClient client = this.session.getDataClient();
        HeapSizeManager heapSizeManager = new HeapSizeManager(AsyncExecutor.ASYNC_MUTATOR_MAX_MEMORY_DEFAULT, 50);
        BatchExecutor batchExecutor = new BatchExecutor(new AsyncExecutor(client, heapSizeManager), this.options, MoreExecutors.listeningDecorator(pool), this.createAdapter(tableName));
        return new BigtableTable(this, tableName, this.options, client, this.createAdapter(tableName), batchExecutor);
    }

    public synchronized BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        TableName tableName = params.getTableName();
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        long maxHeapSize = params.getWriteBufferSize();
        if (maxHeapSize == -1L) {
            params.writeBufferSize(this.tableConfig.getWriteBufferSize());
            maxHeapSize = params.getWriteBufferSize();
        }
        int defaultRpcCount = 50 * this.options.getChannelCount();
        int maxInflightRpcs = this.conf.getInt(MAX_INFLIGHT_RPCS_KEY, defaultRpcCount);
        final long id = SEQUENCE_GENERATOR.incrementAndGet();
        if (this.bufferedMutatorExecutorService == null && this.options.getAsyncMutatorCount() > 0) {
            this.bufferedMutatorExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("BigtableBufferedMutator-worker-%s").setDaemon(true).build());
        }
        BigtableBufferedMutator bigtableBufferedMutator = new BigtableBufferedMutator(this.session.getDataClient(), this.createAdapter(tableName), this.conf, this.options, params.getListener(), new HeapSizeManager(maxHeapSize, maxInflightRpcs), this.bufferedMutatorExecutorService){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    ACTIVE_BUFFERED_MUTATORS.remove(id);
                }
            }
        };
        ACTIVE_BUFFERED_MUTATORS.put(id, bigtableBufferedMutator);
        return bigtableBufferedMutator;
    }

    private HBaseRequestAdapter createAdapter(TableName tableName) {
        return new HBaseRequestAdapter(this.options.getClusterName(), tableName, this.conf);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        long maxMemory = this.conf.getLong(BIGTABLE_BUFFERED_MUTATOR_MAX_MEMORY_KEY, AsyncExecutor.ASYNC_MUTATOR_MAX_MEMORY_DEFAULT);
        return this.getBufferedMutator(new BufferedMutatorParams(tableName).writeBufferSize(maxMemory));
    }

    @Deprecated
    public Table getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        for (RegionLocator locator : locatorCache) {
            if (!locator.getName().equals((Object)tableName)) continue;
            return locator;
        }
        BigtableRegionLocator newLocator = new BigtableRegionLocator(tableName, this.options, this.session.getDataClient());
        if (locatorCache.add(newLocator)) {
            return newLocator;
        }
        for (RegionLocator locator : locatorCache) {
            if (!locator.getName().equals((Object)tableName)) continue;
            return locator;
        }
        throw new IllegalStateException(newLocator + " was supposed to be in the cache");
    }

    public void abort(String msg, Throwable t) {
        if (t != null) {
            this.LOG.fatal(msg, t, new Object[0]);
        } else {
            this.LOG.fatal(msg, new Object[0]);
        }
        this.aborted = true;
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close the connection", e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.session.close();
            this.shutdownBatchPool();
            if (this.bufferedMutatorExecutorService != null) {
                this.bufferedMutatorExecutorService.shutdown();
                this.bufferedMutatorExecutorService = null;
            }
            this.closed = true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(AbstractBigtableConnection.class).add("zone", this.options.getZoneId()).add("project", this.options.getProjectId()).add("cluster", this.options.getClusterId()).add("dataHost", this.options.getDataHost()).add("tableAdminHost", this.options.getTableAdminHost()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() {
        if (this.batchPool == null) {
            AbstractBigtableConnection abstractBigtableConnection = this;
            synchronized (abstractBigtableConnection) {
                if (this.batchPool == null) {
                    int maxThreads = this.getMaxThreads();
                    int minThreads = Math.min(this.getCoreThreads(), maxThreads);
                    long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
                    LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(128 * this.conf.getInt("hbase.client.max.total.tasks", 200));
                    this.batchPool = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)"bigtable-connection-shared-executor"));
                }
                this.cleanupPool = true;
            }
        }
        return this.batchPool;
    }

    private int getCoreThreads() {
        int coreThreads = this.conf.getInt("hbase.hconnection.threads.core", this.options.getChannelCount() * 2);
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        return coreThreads;
    }

    private int getMaxThreads() {
        int maxThreads = this.conf.getInt("hbase.hconnection.threads.max", 256);
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        return maxThreads;
    }

    private void shutdownBatchPool() {
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.batchPool.shutdown();
            try {
                if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.batchPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.batchPool.shutdownNow();
            }
        }
    }

    public abstract Admin getAdmin() throws IOException;

    protected BigtableTableAdminClient getBigtableTableAdminClient() {
        return this.session.getTableAdminClient();
    }

    protected BigtableOptions getOptions() {
        return this.options;
    }

    protected Set<TableName> getDisabledTables() {
        return this.disabledTables;
    }

    public BigtableSession getSession() {
        return this.session;
    }

    static {
        Runnable shutDownRunnable = new Runnable(){

            @Override
            public void run() {
                for (BigtableBufferedMutator bbm : ACTIVE_BUFFERED_MUTATORS.values()) {
                    if (!bbm.hasInflightRequests()) continue;
                    int size = ACTIVE_BUFFERED_MUTATORS.size();
                    new Logger(AbstractBigtableConnection.class).warn("Shutdown is commencing and you have open %d buffered mutators.You need to close() or flush() them so that is not lost", size);
                    break;
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutDownRunnable));
        locatorCache = new CopyOnWriteArraySet<RegionLocator>();
    }
}

