/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.faster.xml.jackson.core.json;

import com.google.bigtable.repackaged.com.faster.xml.jackson.core.JsonGenerationException;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.JsonGenerator;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.ObjectCodec;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.SerializableString;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.Version;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.base.GeneratorBase;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.io.CharTypes;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.io.CharacterEscapes;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.io.IOContext;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.util.DefaultPrettyPrinter;
import com.google.bigtable.repackaged.com.faster.xml.jackson.core.util.VersionUtil;
import java.io.IOException;

public abstract class JsonGeneratorImpl
extends GeneratorBase {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected final IOContext _ioContext;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonGeneratorImpl(IOContext ctxt, int features, ObjectCodec codec) {
        super(features, codec);
        this._ioContext = ctxt;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public JsonGenerator setHighestNonEscapedChar(int charCode) {
        this._maximumNonEscapedChar = charCode < 0 ? 0 : charCode;
        return this;
    }

    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        this._characterEscapes = esc;
        this._outputEscapes = esc == null ? sOutputEscapes : esc.getEscapeCodesForAscii();
        return this;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonGenerator setRootValueSeparator(SerializableString sep) {
        this._rootValueSeparator = sep;
        return this;
    }

    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    public final void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }
}

