/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.http.UrlEncodedContent;
import com.google.bigtable.repackaged.com.google.api.client.json.GenericJson;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebToken;
import com.google.bigtable.repackaged.com.google.api.client.util.ExponentialBackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.api.client.util.Joiner;
import com.google.bigtable.repackaged.com.google.api.client.util.PemReader;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.api.client.util.SecurityUtils;
import com.google.bigtable.repackaged.com.google.auth.ServiceAccountSigner;
import com.google.bigtable.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Date;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class ServiceAccountCredentials
extends GoogleCredentials
implements ServiceAccountSigner {
    private static final long serialVersionUID = 7807543542681217978L;
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final String serviceAccountUser;
    private final String transportFactoryClassName;
    private final URI tokenServerUri;
    private final Collection<String> scopes;
    private transient HttpTransportFactory transportFactory;

    public ServiceAccountCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, Collection<String> scopes) {
        this(clientId, clientEmail, privateKey, privateKeyId, scopes, null, null, null);
    }

    public ServiceAccountCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri) {
        this(clientId, clientEmail, privateKey, privateKeyId, scopes, transportFactory, tokenServerUri, null);
    }

    ServiceAccountCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) {
        this.clientId = clientId;
        this.clientEmail = Preconditions.checkNotNull(clientEmail);
        this.privateKey = Preconditions.checkNotNull(privateKey);
        this.privateKeyId = privateKeyId;
        this.scopes = scopes == null ? ImmutableSet.of() : ImmutableSet.copyOf(scopes);
        this.transportFactory = MoreObjects.firstNonNull(transportFactory, ServiceAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.tokenServerUri = tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : tokenServerUri;
        this.serviceAccountUser = serviceAccountUser;
    }

    static ServiceAccountCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        return ServiceAccountCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, null, transportFactory, null);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes) throws IOException {
        return ServiceAccountCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, scopes, null, null, null);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri) throws IOException {
        return ServiceAccountCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, scopes, transportFactory, tokenServerUri, null);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8(privateKeyPkcs8);
        return new ServiceAccountCredentials(clientId, clientEmail, privateKey, privateKeyId, scopes, transportFactory, tokenServerUri, serviceAccountUser);
    }

    static PrivateKey privateKeyFromPkcs8(String privateKeyPkcs8) throws IOException {
        StringReader reader = new StringReader(privateKeyPkcs8);
        PemReader.Section section = PemReader.readFirstSectionAndClose(reader, "PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS#8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            GeneralSecurityException unexpectedException = exception;
            throw new IOException("Unexpected exception reading PKCS#8 data", unexpectedException);
        }
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ServiceAccountCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        Preconditions.checkNotNull(transportFactory);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, OAuth2Utils.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get("type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if ("service_account".equals(fileType)) {
            return ServiceAccountCredentials.fromJson(fileContents, transportFactory);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s'.", fileType, "service_account"));
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        if (this.createScopedRequired()) {
            throw new IOException("Scopes not configured for service account. Scoped should be specified by calling createScoped or passing scopes to constructor.");
        }
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertion(jsonFactory, currentTime);
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", GRANT_TYPE);
        tokenRequest.set("assertion", assertion);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), content);
        request.setParser(new JsonObjectParser(jsonFactory));
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(new ExponentialBackOff()));
        request.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler(new ExponentialBackOff()).setBackOffRequired(new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

            @Override
            public boolean isRequired(HttpResponse response) {
                int code = response.getStatusCode();
                return code / 100 == 5 || code == 403;
            }
        }));
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException("Error getting access token for service account: ", e);
        }
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes.isEmpty();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return new ServiceAccountCredentials(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, newScopes, this.transportFactory, this.tokenServerUri, this.serviceAccountUser);
    }

    @Override
    public GoogleCredentials createDelegated(String user) {
        return new ServiceAccountCredentials(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.scopes, this.transportFactory, this.tokenServerUri, user);
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    public final String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    @Override
    public String getAccount() {
        return this.getClientEmail();
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(this.getPrivateKey());
            signer.update(toSign);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.transportFactoryClassName, this.tokenServerUri, this.scopes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("clientId", this.clientId).add("clientEmail", this.clientEmail).add("privateKeyId", this.privateKeyId).add("transportFactoryClassName", this.transportFactoryClassName).add("tokenServerUri", this.tokenServerUri).add("scopes", this.scopes).add("serviceAccountUser", this.serviceAccountUser).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientEmail, other.clientEmail) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.tokenServerUri, other.tokenServerUri) && Objects.equals(this.scopes, other.scopes);
    }

    String createAssertion(JsonFactory jsonFactory, long currentTime) throws IOException {
        String assertion;
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(this.clientEmail);
        payload.setAudience(OAuth2Utils.TOKEN_SERVER_URI.toString());
        payload.setIssuedAtTimeSeconds(currentTime / 1000L);
        payload.setExpirationTimeSeconds(currentTime / 1000L + 3600L);
        payload.setSubject(this.serviceAccountUser);
        payload.put("scope", (Object)Joiner.on(' ').join(this.scopes));
        try {
            assertion = JsonWebSignature.signUsingRsaSha256(this.privateKey, jsonFactory, header, payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
        return assertion;
    }
}

