/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public class BulkOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BIGTABLE_ASYNC_MUTATOR_COUNT_DEFAULT = 2;
    public static final long BIGTABLE_BULK_MAX_REQUEST_SIZE_BYTES_DEFAULT = 0x100000L;
    public static final int BIGTABLE_BULK_MAX_ROW_KEY_COUNT_DEFAULT = 25;
    public static final boolean BIGTABLE_BULK_ENABLE_THROTTLE_REBALANCE_DEFAULT = false;
    public static final int BIGTABLE_BULK_THROTTLE_TARGET_MS_DEFAULT = 100;
    public static long BIGTABLE_BULK_AUTOFLUSH_MS_DEFAULT = 0L;
    public static final int BIGTABLE_MAX_INFLIGHT_RPCS_PER_CHANNEL_DEFAULT = 50;
    public static final long BIGTABLE_MAX_MEMORY_DEFAULT = (long)Math.min(1.073741824E9, (double)Runtime.getRuntime().maxMemory() * 0.1);
    private final int asyncMutatorCount;
    private final boolean useBulkApi;
    private final int bulkMaxRowKeyCount;
    private final long bulkMaxRequestSize;
    private final long autoflushMs;
    private final int maxInflightRpcs;
    private final long maxMemory;
    private final boolean enableBulkMutationThrottling;
    private final int bulkMutationRpcTargetMs;

    @VisibleForTesting
    BulkOptions() {
        this.asyncMutatorCount = 1;
        this.useBulkApi = false;
        this.bulkMaxRowKeyCount = -1;
        this.bulkMaxRequestSize = -1L;
        this.autoflushMs = -1L;
        this.maxInflightRpcs = -1;
        this.maxMemory = -1L;
        this.enableBulkMutationThrottling = false;
        this.bulkMutationRpcTargetMs = -1;
    }

    private BulkOptions(int asyncMutatorCount, boolean useBulkApi, int bulkMaxKeyCount, long bulkMaxRequestSize, long autoflushMs, int maxInflightRpcs, long maxMemory, boolean enableBulkMutationThrottling, int bulkMutationRpcTargetMs) {
        this.asyncMutatorCount = asyncMutatorCount;
        this.useBulkApi = useBulkApi;
        this.bulkMaxRowKeyCount = bulkMaxKeyCount;
        this.bulkMaxRequestSize = bulkMaxRequestSize;
        this.autoflushMs = autoflushMs;
        this.maxInflightRpcs = maxInflightRpcs;
        this.maxMemory = maxMemory;
        this.enableBulkMutationThrottling = enableBulkMutationThrottling;
        this.bulkMutationRpcTargetMs = bulkMutationRpcTargetMs;
    }

    public int getAsyncMutatorCount() {
        return this.asyncMutatorCount;
    }

    public boolean useBulkApi() {
        return this.useBulkApi;
    }

    public int getBulkMaxRowKeyCount() {
        return this.bulkMaxRowKeyCount;
    }

    public long getBulkMaxRequestSize() {
        return this.bulkMaxRequestSize;
    }

    public long getAutoflushMs() {
        return this.autoflushMs;
    }

    public int getMaxInflightRpcs() {
        return this.maxInflightRpcs;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public boolean isEnableBulkMutationThrottling() {
        return this.enableBulkMutationThrottling;
    }

    public int getBulkMutationRpcTargetMs() {
        return this.bulkMutationRpcTargetMs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != BulkOptions.class) {
            return false;
        }
        BulkOptions other = (BulkOptions)obj;
        return this.asyncMutatorCount == other.asyncMutatorCount && this.useBulkApi == other.useBulkApi && this.bulkMaxRowKeyCount == other.bulkMaxRowKeyCount && this.bulkMaxRequestSize == other.bulkMaxRequestSize && this.autoflushMs == other.autoflushMs && this.maxInflightRpcs == other.maxInflightRpcs && this.maxMemory == other.maxMemory && this.enableBulkMutationThrottling == other.enableBulkMutationThrottling && this.bulkMutationRpcTargetMs == other.bulkMutationRpcTargetMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("asyncMutatorCount", this.asyncMutatorCount).add("useBulkApi", this.useBulkApi).add("bulkMaxKeyCount", this.bulkMaxRowKeyCount).add("bulkMaxRequestSize", this.bulkMaxRequestSize).add("autoflushMs", this.autoflushMs).add("maxInflightRpcs", this.maxInflightRpcs).add("maxMemory", this.maxMemory).add("enableBulkMutationThrottling", this.enableBulkMutationThrottling).add("bulkMutationRpcTargetMs", this.bulkMutationRpcTargetMs).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private int asyncMutatorCount = 2;
        private boolean useBulkApi = true;
        private int bulkMaxRowKeyCount = 25;
        private long bulkMaxRequestSize = 0x100000L;
        private long autoflushMs = BIGTABLE_BULK_AUTOFLUSH_MS_DEFAULT;
        private int maxInflightRpcs = -1;
        private long maxMemory = BIGTABLE_MAX_MEMORY_DEFAULT;
        private boolean enableBulkMutationThrottling = false;
        private int bulkMutationRpcTargetMs = 100;

        public Builder() {
        }

        private Builder(BulkOptions original) {
            this.asyncMutatorCount = original.asyncMutatorCount;
            this.useBulkApi = original.useBulkApi;
            this.bulkMaxRowKeyCount = original.bulkMaxRowKeyCount;
            this.bulkMaxRequestSize = original.bulkMaxRequestSize;
            this.autoflushMs = original.autoflushMs;
            this.maxInflightRpcs = original.maxInflightRpcs;
            this.maxMemory = original.maxMemory;
            this.enableBulkMutationThrottling = original.enableBulkMutationThrottling;
            this.bulkMutationRpcTargetMs = original.bulkMutationRpcTargetMs;
        }

        public Builder setAsyncMutatorWorkerCount(int asyncMutatorCount) {
            Preconditions.checkArgument(asyncMutatorCount >= 0, "asyncMutatorCount must be greater or equal to 0.");
            this.asyncMutatorCount = asyncMutatorCount;
            return this;
        }

        public Builder setUseBulkApi(boolean useBulkApi) {
            this.useBulkApi = useBulkApi;
            return this;
        }

        public Builder setBulkMaxRowKeyCount(int bulkMaxRowKeyCount) {
            Preconditions.checkArgument(bulkMaxRowKeyCount >= 0, "bulkMaxRowKeyCount must be greater or equal to 0.");
            this.bulkMaxRowKeyCount = bulkMaxRowKeyCount;
            return this;
        }

        public Builder setBulkMaxRequestSize(long bulkMaxRequestSize) {
            Preconditions.checkArgument(bulkMaxRequestSize >= 0L, "bulkMaxRequestSize must be greater or equal to 0.");
            this.bulkMaxRequestSize = bulkMaxRequestSize;
            return this;
        }

        public Builder setAutoflushMs(long autoflushMs) {
            Preconditions.checkArgument(autoflushMs >= 0L, "autoflushMs must be greater or equal to 0.");
            this.autoflushMs = autoflushMs;
            return this;
        }

        public Builder setMaxInflightRpcs(int maxInflightRpcs) {
            Preconditions.checkArgument(maxInflightRpcs > 0, "maxInflightRpcs must be greater than 0.");
            this.maxInflightRpcs = maxInflightRpcs;
            return this;
        }

        public Builder setMaxMemory(long maxMemory) {
            Preconditions.checkArgument(maxMemory > 0L, "maxMemory must be greater than 0.");
            this.maxMemory = maxMemory;
            return this;
        }

        public Builder enableBulkMutationThrottling() {
            this.enableBulkMutationThrottling = true;
            return this;
        }

        public Builder setBulkMutationRpcTargetMs(int bulkMutationRpcTargetMs) {
            this.bulkMutationRpcTargetMs = bulkMutationRpcTargetMs;
            return this;
        }

        public BulkOptions build() {
            return new BulkOptions(this.asyncMutatorCount, this.useBulkApi, this.bulkMaxRowKeyCount, this.bulkMaxRequestSize, this.autoflushMs, this.maxInflightRpcs, this.maxMemory, this.enableBulkMutationThrottling, this.bulkMutationRpcTargetMs);
        }
    }
}

