/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.util.SecurityUtils;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.List;

public class CredentialFactory {
    public static final String CLOUD_BIGTABLE_ADMIN_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.admin";
    public static final String CLOUD_BIGTABLE_READER_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.data.readonly";
    public static final String CLOUD_BIGTABLE_WRITER_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.data";
    public static final List<String> CLOUD_BIGTABLE_READ_WRITE_SCOPES = ImmutableList.of("https://www.googleapis.com/auth/cloud-bigtable.data.readonly", "https://www.googleapis.com/auth/cloud-bigtable.data");
    public static final List<String> CLOUD_BIGTABLE_ALL_SCOPES = ImmutableList.of("https://www.googleapis.com/auth/cloud-bigtable.data.readonly", "https://www.googleapis.com/auth/cloud-bigtable.data", "https://www.googleapis.com/auth/cloud-bigtable.admin");
    private static HttpTransportFactory httpTransportFactory;

    public static void setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
        CredentialFactory.httpTransportFactory = httpTransportFactory;
    }

    public static HttpTransportFactory getHttpTransportFactory() {
        if (httpTransportFactory == null) {
            httpTransportFactory = new HttpTransportFactory(){

                @Override
                public HttpTransport create() {
                    try {
                        return GoogleNetHttpTransport.newTrustedTransport();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not create a GoogleNetHttpTransport: " + e.getMessage(), e);
                    }
                }
            };
        }
        return httpTransportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Credentials getCredentials(CredentialOptions options) throws IOException, GeneralSecurityException {
        switch (options.getCredentialType()) {
            case DefaultCredentials: {
                return CredentialFactory.getApplicationDefaultCredential();
            }
            case P12: {
                CredentialOptions.P12CredentialOptions p12Options = (CredentialOptions.P12CredentialOptions)options;
                return CredentialFactory.getCredentialFromPrivateKeyServiceAccount(p12Options.getServiceAccount(), p12Options.getKeyFile());
            }
            case SuppliedCredentials: {
                return ((CredentialOptions.UserSuppliedCredentialOptions)options).getCredential();
            }
            case SuppliedJson: {
                CredentialOptions.JsonCredentialsOptions jsonCredentialsOptions;
                CredentialOptions.JsonCredentialsOptions jsonCredentialsOptions2 = jsonCredentialsOptions = (CredentialOptions.JsonCredentialsOptions)options;
                synchronized (jsonCredentialsOptions2) {
                    if (jsonCredentialsOptions.getCachedCredentials() == null) {
                        jsonCredentialsOptions.setCachedCredentails(CredentialFactory.getInputStreamCredential(jsonCredentialsOptions.getInputStream()));
                    }
                    return jsonCredentialsOptions.getCachedCredentials();
                }
            }
            case None: {
                return null;
            }
        }
        throw new IllegalStateException("Cannot process Credential type: " + (Object)((Object)options.getCredentialType()));
    }

    public static Credentials getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        return new ComputeEngineCredentials(CredentialFactory.getHttpTransportFactory());
    }

    public static Credentials getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile) throws IOException, GeneralSecurityException {
        return CredentialFactory.getCredentialFromPrivateKeyServiceAccount(serviceAccountEmail, privateKeyFile, CLOUD_BIGTABLE_ALL_SCOPES);
    }

    public static Credentials getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes) throws IOException, GeneralSecurityException {
        String clientId = null;
        String privateKeyId = null;
        PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore(SecurityUtils.getPkcs12KeyStore(), new FileInputStream(privateKeyFile), "notasecret", "privatekey", "notasecret");
        return new ServiceAccountCredentials(clientId, serviceAccountEmail, privateKey, privateKeyId, scopes, CredentialFactory.getHttpTransportFactory(), null);
    }

    public static Credentials getApplicationDefaultCredential() throws IOException, GeneralSecurityException {
        return GoogleCredentials.getApplicationDefault(CredentialFactory.getHttpTransportFactory()).createScoped(CLOUD_BIGTABLE_ALL_SCOPES);
    }

    public static Credentials getInputStreamCredential(InputStream inputStream) throws IOException, GeneralSecurityException {
        return GoogleCredentials.fromStream(inputStream, CredentialFactory.getHttpTransportFactory()).createScoped(CLOUD_BIGTABLE_ALL_SCOPES);
    }
}

