/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.CallOptionsFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.RetryingMutateRowsOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.RetryingStreamOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.RetryingUnaryOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRowConverter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResumingStreamingResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.RetryingReadRowsOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.base.Predicates;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public class BigtableDataGrpcClient
implements BigtableDataClient {
    @VisibleForTesting
    public static final Predicate<MutateRowRequest> IS_RETRYABLE_MUTATION = new Predicate<MutateRowRequest>(){

        @Override
        public boolean apply(MutateRowRequest mutateRowRequest) {
            return mutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(mutateRowRequest.getMutationsList());
        }
    };
    private static final Predicate<MutateRowsRequest> ARE_RETRYABLE_MUTATIONS = new Predicate<MutateRowsRequest>(){

        @Override
        public boolean apply(MutateRowsRequest mutateRowsRequest) {
            if (mutateRowsRequest == null) {
                return false;
            }
            for (MutateRowsRequest.Entry entry : mutateRowsRequest.getEntriesList()) {
                if (BigtableDataGrpcClient.allCellsHaveTimestamps(entry.getMutationsList())) continue;
                return false;
            }
            return true;
        }
    };
    private static final Predicate<CheckAndMutateRowRequest> IS_RETRYABLE_CHECK_AND_MUTATE = new Predicate<CheckAndMutateRowRequest>(){

        @Override
        public boolean apply(CheckAndMutateRowRequest checkAndMutateRowRequest) {
            return checkAndMutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getTrueMutationsList()) && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getFalseMutationsList());
        }
    };
    private static Function<FlatRow, Row> FLAT_ROW_TRANSFORMER = new Function<FlatRow, Row>(){

        @Override
        public Row apply(FlatRow input) {
            return FlatRowConverter.convert(input);
        }
    };
    private static Function<List<ReadRowsResponse>, List<FlatRow>> FLAT_ROW_LIST_TRANSFORMER = new Function<List<ReadRowsResponse>, List<FlatRow>>(){

        @Override
        public List<FlatRow> apply(List<ReadRowsResponse> responses) {
            return RowMerger.toRows(responses);
        }
    };
    private static Function<List<ReadRowsResponse>, List<Row>> ROW_LIST_TRANSFORMER = new Function<List<ReadRowsResponse>, List<Row>>(){

        @Override
        public List<Row> apply(List<ReadRowsResponse> responses) {
            return Lists.transform(RowMerger.toRows(responses), FLAT_ROW_TRANSFORMER);
        }
    };
    private final ScheduledExecutorService retryExecutorService;
    private final RetryOptions retryOptions;
    private CallOptionsFactory callOptionsFactory = new CallOptionsFactory.Default();
    private final BigtableAsyncRpc<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysAsync;
    private final BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> readRowsAsync;
    @VisibleForTesting
    final BigtableAsyncRpc<MutateRowRequest, MutateRowResponse> mutateRowRpc;
    @VisibleForTesting
    final BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> mutateRowsRpc;
    @VisibleForTesting
    final BigtableAsyncRpc<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRpc;
    private final BigtableAsyncRpc<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readWriteModifyRpc;

    private static final boolean allCellsHaveTimestamps(Iterable<Mutation> mutations) {
        for (Mutation mut : mutations) {
            if (mut.getSetCell().getTimestampMicros() > 0L) continue;
            return false;
        }
        return true;
    }

    public BigtableDataGrpcClient(Channel channel, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        this.retryExecutorService = retryExecutorService;
        this.retryOptions = bigtableOptions.getRetryOptions();
        BigtableAsyncUtilities.Default asyncUtilities = new BigtableAsyncUtilities.Default(channel);
        this.sampleRowKeysAsync = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_SAMPLE_ROW_KEYS, Predicates.alwaysTrue());
        this.readRowsAsync = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_READ_ROWS, Predicates.alwaysTrue());
        this.mutateRowRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_MUTATION));
        this.mutateRowsRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_MUTATE_ROWS, this.getMutationRetryableFunction(ARE_RETRYABLE_MUTATIONS));
        this.checkAndMutateRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_CHECK_AND_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_CHECK_AND_MUTATE));
        this.readWriteModifyRpc = asyncUtilities.createAsyncRpc(BigtableGrpc.METHOD_READ_MODIFY_WRITE_ROW, Predicates.alwaysFalse());
    }

    @Override
    public void setCallOptionsFactory(CallOptionsFactory callOptionsFactory) {
        this.callOptionsFactory = callOptionsFactory;
    }

    private <T> Predicate<T> getMutationRetryableFunction(Predicate<T> isRetryableMutation) {
        if (this.retryOptions.allowRetriesWithoutTimestamp()) {
            return new Predicate<T>(){

                @Override
                public boolean apply(@Nullable T input) {
                    return input != null;
                }
            };
        }
        return isRetryableMutation;
    }

    @Override
    public MutateRowResponse mutateRow(MutateRowRequest request) {
        return (MutateRowResponse)this.createUnaryListener(request, this.mutateRowRpc, request.getTableName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<MutateRowResponse> mutateRowAsync(MutateRowRequest request) {
        return this.createUnaryListener(request, this.mutateRowRpc, request.getTableName()).getAsyncResult();
    }

    @Override
    public List<MutateRowsResponse> mutateRows(MutateRowsRequest request) {
        return (List)this.createMutateRowsOperation(request).getBlockingResult();
    }

    @Override
    public ListenableFuture<List<MutateRowsResponse>> mutateRowsAsync(MutateRowsRequest request) {
        return this.createMutateRowsOperation(request).getAsyncResult();
    }

    private RetryingMutateRowsOperation createMutateRowsOperation(MutateRowsRequest request) {
        CallOptions callOptions = this.getCallOptions(this.mutateRowsRpc.getMethodDescriptor(), request);
        Metadata metadata = this.createMetadata(request.getTableName());
        return new RetryingMutateRowsOperation(this.retryOptions, request, this.mutateRowsRpc, callOptions, this.retryExecutorService, metadata);
    }

    @Override
    public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) {
        return (CheckAndMutateRowResponse)this.createUnaryListener(request, this.checkAndMutateRpc, request.getTableName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) {
        return this.createUnaryListener(request, this.checkAndMutateRpc, request.getTableName()).getAsyncResult();
    }

    @Override
    public ReadModifyWriteRowResponse readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return (ReadModifyWriteRowResponse)this.createUnaryListener(request, this.readWriteModifyRpc, request.getTableName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<ReadModifyWriteRowResponse> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) {
        return this.createUnaryListener(request, this.readWriteModifyRpc, request.getTableName()).getAsyncResult();
    }

    @Override
    public List<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
        return (List)this.createStreamingListener(request, this.sampleRowKeysAsync, request.getTableName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<List<SampleRowKeysResponse>> sampleRowKeysAsync(SampleRowKeysRequest request) {
        return this.createStreamingListener(request, this.sampleRowKeysAsync, request.getTableName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.createStreamingListener(request, this.readRowsAsync, request.getTableName()).getAsyncResult(), ROW_LIST_TRANSFORMER);
    }

    @Override
    public ListenableFuture<List<FlatRow>> readFlatRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.createStreamingListener(request, this.readRowsAsync, request.getTableName()).getAsyncResult(), FLAT_ROW_LIST_TRANSFORMER);
    }

    @Override
    public List<FlatRow> readFlatRowsList(ReadRowsRequest request) {
        return FLAT_ROW_LIST_TRANSFORMER.apply((List<ReadRowsResponse>)this.createStreamingListener(request, this.readRowsAsync, request.getTableName()).getBlockingResult());
    }

    private <ReqT, RespT> RetryingUnaryOperation<ReqT, RespT> createUnaryListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        CallOptions callOptions = this.getCallOptions(rpc.getMethodDescriptor(), request);
        Metadata metadata = this.createMetadata(tableName);
        return new RetryingUnaryOperation<ReqT, RespT>(this.retryOptions, request, rpc, callOptions, this.retryExecutorService, metadata);
    }

    private <ReqT, RespT> RetryingStreamOperation<ReqT, RespT> createStreamingListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        CallOptions callOptions = this.getCallOptions(rpc.getMethodDescriptor(), request);
        Metadata metadata = this.createMetadata(tableName);
        return new RetryingStreamOperation<ReqT, RespT>(this.retryOptions, request, rpc, callOptions, this.retryExecutorService, metadata);
    }

    private <ReqT> CallOptions getCallOptions(MethodDescriptor<ReqT, ?> methodDescriptor, ReqT request) {
        return this.callOptionsFactory.create(methodDescriptor, request);
    }

    private Metadata createMetadata(String tableName) {
        Metadata metadata = new Metadata();
        if (tableName != null) {
            metadata.put(GoogleCloudResourcePrefixInterceptor.GRPC_RESOURCE_PREFIX_KEY, tableName);
        }
        return metadata;
    }

    @Override
    public ResultScanner<Row> readRows(ReadRowsRequest request) {
        final ResultScanner<FlatRow> delegate = this.readFlatRows(request);
        return new ResultScanner<Row>(){

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            public Row[] next(int count) throws IOException {
                FlatRow[] flatRows = (FlatRow[])delegate.next(count);
                Row[] rows = new Row[flatRows.length];
                for (int i = 0; i < flatRows.length; ++i) {
                    rows[i] = FlatRowConverter.convert(flatRows[i]);
                }
                return rows;
            }

            @Override
            public Row next() throws IOException {
                return FlatRowConverter.convert((FlatRow)delegate.next());
            }

            @Override
            public int available() {
                return delegate.available();
            }
        };
    }

    @Override
    public ResultScanner<FlatRow> readFlatRows(ReadRowsRequest request) {
        final ResponseQueueReader reader = new ResponseQueueReader();
        RetryingReadRowsOperation operation = this.createReadRowsRetryListener(request, reader);
        operation.setResultObserver(new StreamObserver<ReadRowsResponse>(){

            @Override
            public void onNext(ReadRowsResponse value) {
                reader.addRequestResultMarker();
            }

            @Override
            public void onError(Throwable t) {
            }

            @Override
            public void onCompleted() {
            }
        });
        operation.getAsyncResult();
        return new ResumingStreamingResultScanner(reader, operation);
    }

    @Override
    public ScanHandler readFlatRows(ReadRowsRequest request, StreamObserver<FlatRow> observer) {
        RetryingReadRowsOperation operation = this.createReadRowsRetryListener(request, observer);
        operation.getAsyncResult();
        return operation;
    }

    private RetryingReadRowsOperation createReadRowsRetryListener(ReadRowsRequest request, StreamObserver<FlatRow> observer) {
        return new RetryingReadRowsOperation(observer, this.retryOptions, request, this.readRowsAsync, this.getCallOptions(this.readRowsAsync.getMethodDescriptor(), request), this.retryExecutorService, this.createMetadata(request.getTableName()));
    }
}

