/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableVersionInfo;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BulkOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableClusterUtilities;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.CallOptionsFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BulkRead;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.ResourceLimiterStats;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.ThrottlingClientInterceptor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.CredentialInterceptorCache;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.internal.DnsNameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContext;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContextBuilder;
import com.google.bigtable.repackaged.io.netty.util.Recycler;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class BigtableSession
implements Closeable {
    private static final Logger LOG = new Logger(BigtableSession.class);
    private static ChannelPool cachedDataChannelPool;
    private static final Map<String, ResourceLimiter> resourceLimiterMap;
    private static SslContextBuilder sslBuilder;
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    @VisibleForTesting
    static final String PROJECT_ID_EMPTY_OR_NULL = "ProjectId must not be empty or null.";
    @VisibleForTesting
    static final String INSTANCE_ID_EMPTY_OR_NULL = "InstanceId must not be empty or null.";
    @VisibleForTesting
    static final String USER_AGENT_EMPTY_OR_NULL = "UserAgent must not be empty or null";
    private final BigtableDataClient dataClient;
    private final BigtableDataClient throttlingDataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableInstanceGrpcClient instanceAdminClient;
    private final BigtableOptions options;
    private final List<ManagedChannel> managedChannels = Collections.synchronizedList(new ArrayList());
    private final ClientInterceptor[] clientInterceptors;
    private BigtableClusterName clusterName;

    @VisibleForTesting
    static void turnOffNettyRecycler() {
        String packageName = Recycler.class.getName();
        String prefix = packageName.substring(0, packageName.indexOf(".util.Recycler"));
        String key = prefix + ".recycler.maxCapacity";
        LOG.debug("Using prefix %s for io.netty.", prefix);
        if (System.getProperty(key) == null) {
            System.setProperty(key, "0");
        }
    }

    private static synchronized SslContext createSslContext() throws SSLException {
        if (sslBuilder == null) {
            sslBuilder = GrpcSslContexts.forClient().ciphers(null);
        }
        return sslBuilder.build();
    }

    private static void performWarmup() {
        ExecutorService connectionStartupExecutor = Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("BigtableSession-startup-%d", true));
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                BigtableSessionSharedThreadPools.getInstance();
            }
        });
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BigtableSession.createSslContext();
                }
                catch (SSLException sSLException) {
                    // empty catch block
                }
            }
        });
        for (final String host : Arrays.asList("bigtable.googleapis.com", "bigtableadmin.googleapis.com")) {
            connectionStartupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            });
        }
        connectionStartupExecutor.shutdown();
    }

    private static synchronized ResourceLimiter initializeResourceLimiter(BigtableOptions options) {
        BigtableInstanceName instanceName = options.getInstanceName();
        String key = instanceName.toString();
        ResourceLimiter resourceLimiter = resourceLimiterMap.get(key);
        if (resourceLimiter == null) {
            int maxInflightRpcs = options.getBulkOptions().getMaxInflightRpcs();
            long maxMemory = options.getBulkOptions().getMaxMemory();
            ResourceLimiterStats stats = ResourceLimiterStats.getInstance(instanceName);
            resourceLimiter = new ResourceLimiter(stats, maxMemory, maxInflightRpcs);
            BulkOptions bulkOptions = options.getBulkOptions();
            if (bulkOptions.isEnableBulkMutationThrottling()) {
                resourceLimiter.throttle(bulkOptions.getBulkMutationRpcTargetMs());
            }
            resourceLimiterMap.put(key, resourceLimiter);
        }
        return resourceLimiter;
    }

    public BigtableSession(BigtableOptions opts) throws IOException {
        this.options = opts;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.options.getProjectId()), PROJECT_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.options.getInstanceId()), INSTANCE_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.options.getUserAgent()), USER_AGENT_EMPTY_OR_NULL);
        LOG.info("Opening connection for projectId %s, instanceId %s, on data host %s, table admin host %s.", this.options.getProjectId(), this.options.getInstanceId(), this.options.getDataHost(), this.options.getTableAdminHost());
        LOG.info("Bigtable options: %s.", this.options);
        ArrayList<ClientInterceptor> clientInterceptorsList = new ArrayList<ClientInterceptor>();
        clientInterceptorsList.add(new GoogleCloudResourcePrefixInterceptor(this.options.getInstanceName().toString()));
        CredentialInterceptorCache credentialsCache = CredentialInterceptorCache.getInstance();
        RetryOptions retryOptions = this.options.getRetryOptions();
        CredentialOptions credentialOptions = this.options.getCredentialOptions();
        try {
            ClientInterceptor credentialsInterceptor = credentialsCache.getCredentialsInterceptor(credentialOptions, retryOptions);
            if (credentialsInterceptor != null) {
                clientInterceptorsList.add(credentialsInterceptor);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not initialize credentials.", e);
        }
        this.clientInterceptors = clientInterceptorsList.toArray(new ClientInterceptor[clientInterceptorsList.size()]);
        ChannelPool dataChannel = this.getDataChannelPool();
        BigtableSessionSharedThreadPools sharedPools = BigtableSessionSharedThreadPools.getInstance();
        CallOptionsFactory.ConfiguredCallOptionsFactory callOptionsFactory = new CallOptionsFactory.ConfiguredCallOptionsFactory(this.options.getCallOptionsConfig());
        this.dataClient = new BigtableDataGrpcClient(dataChannel, sharedPools.getRetryExecutor(), this.options);
        this.dataClient.setCallOptionsFactory(callOptionsFactory);
        ResourceLimiter resourceLimiter = BigtableSession.initializeResourceLimiter(this.options);
        Channel asyncDataChannel = ClientInterceptors.intercept((Channel)dataChannel, new ThrottlingClientInterceptor(resourceLimiter));
        this.throttlingDataClient = new BigtableDataGrpcClient(asyncDataChannel, sharedPools.getRetryExecutor(), this.options);
        BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "sessions.active").inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPool getDataChannelPool() throws IOException {
        String host = this.options.getDataHost();
        int channelCount = this.options.getChannelCount();
        if (this.options.useCachedChannel()) {
            Class<BigtableSession> clazz = BigtableSession.class;
            synchronized (BigtableSession.class) {
                if (cachedDataChannelPool == null) {
                    cachedDataChannelPool = this.createChannelPool(host, channelCount);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return cachedDataChannelPool;
            }
        }
        return this.createManagedPool(host, channelCount);
    }

    public synchronized BigtableClusterName getClusterName() throws IOException {
        if (this.clusterName == null) {
            try (BigtableClusterUtilities util = BigtableClusterUtilities.forInstance(this.options.getProjectId(), this.options.getInstanceId());){
                ListClustersResponse clusters = util.getClusters();
                Preconditions.checkState(clusters.getClustersCount() == 1, String.format("Project '%s' / Instance '%s' has %d clusters. There must be exactly 1 for this operation to work.", this.options.getProjectId(), this.options.getInstanceId(), clusters.getClustersCount()));
                this.clusterName = new BigtableClusterName(clusters.getClusters(0).getName());
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Could not get cluster Id.", e);
            }
        }
        return this.clusterName;
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public AsyncExecutor createAsyncExecutor() {
        return new AsyncExecutor(this.throttlingDataClient);
    }

    @Deprecated
    public BulkMutation createBulkMutation(BigtableTableName tableName, AsyncExecutor asyncExecutor) {
        return this.createBulkMutation(tableName);
    }

    public BulkMutation createBulkMutation(BigtableTableName tableName) {
        return new BulkMutation(tableName, this.throttlingDataClient, BigtableSessionSharedThreadPools.getInstance().getRetryExecutor(), this.options.getBulkOptions());
    }

    public BulkRead createBulkRead(BigtableTableName tableName) {
        return new BulkRead(this.dataClient, tableName, this.options.getBulkOptions().getBulkMaxRowKeyCount(), BigtableSessionSharedThreadPools.getInstance().getBatchThreadPool());
    }

    public synchronized BigtableTableAdminClient getTableAdminClient() throws IOException {
        if (this.tableAdminClient == null) {
            ChannelPool channel = this.createChannelPool(this.options.getTableAdminHost(), 1);
            this.tableAdminClient = new BigtableTableAdminGrpcClient(channel, BigtableSessionSharedThreadPools.getInstance().getRetryExecutor(), this.options);
        }
        return this.tableAdminClient;
    }

    public synchronized BigtableInstanceClient getInstanceAdminClient() throws IOException {
        if (this.instanceAdminClient == null) {
            ChannelPool channel = this.createChannelPool(this.options.getInstanceAdminHost(), 1);
            this.instanceAdminClient = new BigtableInstanceGrpcClient(channel);
        }
        return this.instanceAdminClient;
    }

    protected ChannelPool createChannelPool(final String hostString, int count) throws IOException {
        ChannelPool.ChannelFactory channelFactory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(hostString, BigtableSession.this.options, BigtableSession.this.clientInterceptors);
            }
        };
        return new ChannelPool(channelFactory, count);
    }

    protected ChannelPool createManagedPool(String host, int channelCount) throws IOException {
        ChannelPool channelPool = this.createChannelPool(host, channelCount);
        this.managedChannels.add(channelPool);
        return channelPool;
    }

    public static ChannelPool createChannelPool(String host, BigtableOptions options) throws IOException, GeneralSecurityException {
        return BigtableSession.createChannelPool(host, options, 1);
    }

    public static ChannelPool createChannelPool(final String host, final BigtableOptions options, int count) throws IOException, GeneralSecurityException {
        final ClientInterceptor credentialsInterceptor = CredentialInterceptorCache.getInstance().getCredentialsInterceptor(options.getCredentialOptions(), options.getRetryOptions());
        final GoogleCloudResourcePrefixInterceptor prefixInterceptor = new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString());
        return new ChannelPool(new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(host, options, credentialsInterceptor, prefixInterceptor);
            }
        }, count);
    }

    public static ManagedChannel createNettyChannel(String host, BigtableOptions options, ClientInterceptor ... interceptors) throws SSLException {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress(host, options.getPort());
        if (options.usePlaintextNegotiation()) {
            builder.usePlaintext(true);
        } else {
            builder.sslContext(BigtableSession.createSslContext());
        }
        return ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)builder.nameResolverFactory(new DnsNameResolverProvider())).idleTimeout(Long.MAX_VALUE, TimeUnit.SECONDS)).maxInboundMessageSize(0x10000000)).userAgent(BigtableVersionInfo.CORE_UESR_AGENT + "," + options.getUserAgent())).intercept(interceptors)).build();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.managedChannels.isEmpty()) {
            return;
        }
        long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        for (ManagedChannel channel : this.managedChannels) {
            channel.shutdown();
        }
        for (ManagedChannel channel : this.managedChannels) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            try {
                channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while closing the channelPools");
            }
        }
        for (ManagedChannel channel : this.managedChannels) {
            if (channel.isTerminated()) continue;
            LOG.info("Could not close the channel after 10 seconds.", new Object[0]);
            break;
        }
        this.managedChannels.clear();
        BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "sessions.active").dec();
    }

    public BigtableOptions getOptions() {
        return this.options;
    }

    static {
        resourceLimiterMap = new HashMap<String, ResourceLimiter>();
        BigtableSession.turnOffNettyRecycler();
        BigtableSession.performWarmup();
    }
}

