/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class BigtableSessionSharedThreadPools {
    private static final String BATCH_POOL_THREAD_NAME_PATTERN = "bigtable-batch-pool-%d";
    private static final String RETRY_THREADPOOL_NAME_PATTERN = "bigtable-rpc-retry-%d";
    public static final int RETRY_THREAD_COUNT = 4;
    private static BigtableSessionSharedThreadPools INSTANCE = new BigtableSessionSharedThreadPools();
    protected ExecutorService batchThreadPool;
    protected ScheduledExecutorService retryExecutor;

    public static BigtableSessionSharedThreadPools getInstance() {
        return INSTANCE;
    }

    public synchronized ExecutorService getBatchThreadPool() {
        if (this.batchThreadPool == null) {
            this.batchThreadPool = Executors.newCachedThreadPool(GrpcUtil.getThreadFactory(BATCH_POOL_THREAD_NAME_PATTERN, true));
        }
        return this.batchThreadPool;
    }

    public synchronized ScheduledExecutorService getRetryExecutor() {
        if (this.retryExecutor == null) {
            this.retryExecutor = Executors.newScheduledThreadPool(4, GrpcUtil.getThreadFactory(RETRY_THREADPOOL_NAME_PATTERN, true));
        }
        return this.retryExecutor;
    }
}

