/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.BigtableTableAdminGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.RetryingUnaryOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.bigtable.repackaged.com.google.common.base.Predicates;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import java.util.concurrent.ScheduledExecutorService;

public class BigtableTableAdminGrpcClient
implements BigtableTableAdminClient {
    private final BigtableAsyncRpc<ListTablesRequest, ListTablesResponse> listTablesRpc;
    private final RetryOptions retryOptions;
    private final ScheduledExecutorService retryExecutorService;
    private final BigtableAsyncRpc<GetTableRequest, Table> getTableRpc;
    private final BigtableAsyncRpc<CreateTableRequest, Table> createTableRpc;
    private final BigtableAsyncRpc<ModifyColumnFamiliesRequest, Table> modifyColumnFamilyRpc;
    private final BigtableAsyncRpc<DeleteTableRequest, Empty> deleteTableRpc;
    private final BigtableAsyncRpc<DropRowRangeRequest, Empty> dropRowRangeRpc;

    public BigtableTableAdminGrpcClient(Channel channel, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        BigtableAsyncUtilities.Default asyncUtilities = new BigtableAsyncUtilities.Default(channel);
        this.listTablesRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_LIST_TABLES, Predicates.alwaysTrue());
        this.getTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_GET_TABLE, Predicates.alwaysTrue());
        this.createTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_CREATE_TABLE, Predicates.alwaysFalse());
        this.modifyColumnFamilyRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_MODIFY_COLUMN_FAMILIES, Predicates.alwaysFalse());
        this.deleteTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_DELETE_TABLE, Predicates.alwaysFalse());
        this.dropRowRangeRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.METHOD_DROP_ROW_RANGE, Predicates.alwaysFalse());
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.retryExecutorService = retryExecutorService;
    }

    @Override
    public ListTablesResponse listTables(ListTablesRequest request) {
        return (ListTablesResponse)this.createUnaryListener(request, this.listTablesRpc, request.getParent()).getBlockingResult();
    }

    @Override
    public Table getTable(GetTableRequest request) {
        return (Table)this.createUnaryListener(request, this.getTableRpc, request.getName()).getBlockingResult();
    }

    @Override
    public void createTable(CreateTableRequest request) {
        this.createUnaryListener(request, this.createTableRpc, request.getParent()).getBlockingResult();
    }

    @Override
    public void modifyColumnFamily(ModifyColumnFamiliesRequest request) {
        this.createUnaryListener(request, this.modifyColumnFamilyRpc, request.getName()).getBlockingResult();
    }

    @Override
    public void deleteTable(DeleteTableRequest request) {
        this.createUnaryListener(request, this.deleteTableRpc, request.getName()).getBlockingResult();
    }

    @Override
    public void dropRowRange(DropRowRangeRequest request) {
        this.createUnaryListener(request, this.dropRowRangeRpc, request.getName()).getBlockingResult();
    }

    private <ReqT, RespT> RetryingUnaryOperation<ReqT, RespT> createUnaryListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String resource) {
        CallOptions callOptions = CallOptions.DEFAULT;
        Metadata metadata = this.createMetadata(resource);
        return new RetryingUnaryOperation<ReqT, RespT>(this.retryOptions, request, rpc, callOptions, this.retryExecutorService, metadata);
    }

    private Metadata createMetadata(String resource) {
        Metadata metadata = new Metadata();
        if (resource != null) {
            metadata.put(GoogleCloudResourcePrefixInterceptor.GRPC_RESOURCE_PREFIX_KEY, resource);
        }
        return metadata;
    }
}

