/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CallOptionsConfig;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;

public interface CallOptionsFactory {
    public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> var1, RequestT var2);

    public static class ConfiguredCallOptionsFactory
    implements CallOptionsFactory {
        private final CallOptionsConfig config;

        public ConfiguredCallOptionsFactory(CallOptionsConfig config) {
            this.config = config;
        }

        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            if (!this.config.isUseTimeout() || request == null) {
                return CallOptions.DEFAULT;
            }
            int timeout = this.config.getShortRpcTimeoutMs();
            if (ConfiguredCallOptionsFactory.isLongRequest(descriptor, request)) {
                timeout = this.config.getLongRpcTimeoutMs();
            }
            return CallOptions.DEFAULT.withDeadline(Deadline.after(timeout, TimeUnit.MILLISECONDS));
        }

        public static <RequestT> boolean isLongRequest(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            return descriptor == BigtableGrpc.METHOD_MUTATE_ROWS || !ConfiguredCallOptionsFactory.isGet(request);
        }

        public static boolean isGet(Object request) {
            if (request.getClass() != ReadRowsRequest.class) {
                return false;
            }
            RowSet rowSet = ((ReadRowsRequest)request).getRows();
            return rowSet != null && rowSet.getRowRangesCount() == 0 && rowSet.getRowKeysCount() == 1;
        }
    }

    public static class Default
    implements CallOptionsFactory {
        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            return CallOptions.DEFAULT;
        }
    }
}

