/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Sleeper;
import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.CallOptionsFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractRetryingOperation<RequestT, ResponseT, ResultT>
extends ClientCall.Listener<ResponseT> {
    protected static final Logger LOG = new Logger(AbstractRetryingOperation.class);
    protected static final long UNARY_DEADLINE_MINUTES = 6L;
    protected BackOff currentBackoff;
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    protected final BigtableAsyncRpc<RequestT, ResponseT> rpc;
    protected final RetryOptions retryOptions;
    protected final ScheduledExecutorService retryExecutorService;
    private final RequestT request;
    private final CallOptions callOptions;
    private final Metadata originalMetadata;
    protected int failedCount = 0;
    protected final GrpcFuture<ResultT> completionFuture;
    protected Object callLock = new String("");
    protected ClientCall<RequestT, ResponseT> call;
    protected Timer.Context operationTimerContext;
    protected Timer.Context rpcTimerContext;

    public AbstractRetryingOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService retryExecutorService, Metadata originalMetadata) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.rpc = retryableRpc;
        this.callOptions = callOptions;
        this.retryExecutorService = retryExecutorService;
        this.originalMetadata = originalMetadata;
        this.completionFuture = new GrpcFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(Status status, Metadata trailers) {
        Object object = this.callLock;
        synchronized (object) {
            this.call = null;
        }
        this.rpcTimerContext.close();
        if (status.isOk()) {
            if (this.onOK(trailers)) {
                this.operationTimerContext.close();
            }
        } else {
            this.onError(status, trailers);
        }
    }

    protected void onError(Status status, Metadata trailers) {
        Status.Code code = status.getCode();
        if (code == Status.Code.CANCELLED) {
            this.completionFuture.setException(status.asRuntimeException());
            this.operationTimerContext.close();
            return;
        }
        if (!this.retryOptions.enableRetries() || !this.retryOptions.isRetryable(code) || !this.isRequestRetryable() && code != Status.Code.UNAUTHENTICATED && code != Status.Code.UNAVAILABLE) {
            this.rpc.getRpcMetrics().markFailure();
            this.operationTimerContext.close();
            this.setException(status.asRuntimeException());
            return;
        }
        long nextBackOff = this.getNextBackoff();
        ++this.failedCount;
        if (nextBackOff == -1L) {
            this.setException(this.getExhaustedRetriesException(status));
        } else {
            String channelId = ChannelPool.extractIdentifier(trailers);
            LOG.info("Retrying failed call. Failure #%d, got: %s on channel %s", status.getCause(), this.failedCount, status, channelId);
            this.performRetry(nextBackOff);
        }
    }

    protected BigtableRetriesExhaustedException getExhaustedRetriesException(Status status) {
        this.rpc.getRpcMetrics().markRetriesExhasted();
        this.operationTimerContext.close();
        String message = String.format("Exhausted retries after %d failures.", this.failedCount);
        return new BigtableRetriesExhaustedException(message, status.asRuntimeException());
    }

    protected void performRetry(long nextBackOff) {
        this.rpc.getRpcMetrics().markRetry();
        this.retryExecutorService.schedule(this.getRunnable(), nextBackOff, TimeUnit.MILLISECONDS);
    }

    protected Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractRetryingOperation.this.run();
            }
        };
    }

    protected boolean isRequestRetryable() {
        return this.rpc.isRetryable(this.getRetryRequest());
    }

    protected void setException(Exception exception) {
        this.completionFuture.setException(exception);
    }

    protected abstract boolean onOK(Metadata var1);

    protected long getNextBackoff() {
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        try {
            return this.currentBackoff.nextBackOffMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        this.rpcTimerContext = this.rpc.getRpcMetrics().timeRpc();
        Metadata metadata = new Metadata();
        metadata.merge(this.originalMetadata);
        Object object = this.callLock;
        synchronized (object) {
            this.call = this.rpc.newCall(this.getCallOptions());
            this.rpc.start(this.getRetryRequest(), this, metadata, this.call);
        }
    }

    protected CallOptions getCallOptions() {
        if (this.callOptions.getDeadline() != null) {
            return this.callOptions;
        }
        MethodDescriptor<RequestT, ResponseT> methodDescriptor = this.rpc.getMethodDescriptor();
        if (methodDescriptor.getType() != MethodDescriptor.MethodType.UNARY && methodDescriptor == BigtableGrpc.METHOD_READ_ROWS && !CallOptionsFactory.ConfiguredCallOptionsFactory.isGet(this.request)) {
            return this.callOptions;
        }
        return this.callOptions.withDeadlineAfter(6L, TimeUnit.MINUTES);
    }

    protected RequestT getRetryRequest() {
        return this.request;
    }

    public final RequestT getOriginalRequest() {
        return this.request;
    }

    public ListenableFuture<ResultT> getAsyncResult() {
        Preconditions.checkState(this.operationTimerContext == null);
        this.operationTimerContext = this.rpc.getRpcMetrics().timeOperation();
        this.run();
        return this.completionFuture;
    }

    public void cancel() {
        this.cancel("User requested cancelation.");
    }

    public ResultT getBlockingResult() {
        try {
            return (ResultT)this.getAsyncResult().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.cancel();
            throw Status.CANCELLED.withCause(e).asRuntimeException();
        }
        catch (ExecutionException e) {
            this.cancel();
            throw Status.fromThrowable(e).asRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(String message) {
        Object object = this.callLock;
        synchronized (object) {
            if (this.call != null) {
                this.call.cancel(message, null);
                this.call = null;
            }
        }
    }

    protected class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        protected GrpcFuture() {
        }

        @Override
        protected void interruptTask() {
            if (!this.isDone()) {
                AbstractRetryingOperation.this.cancel("Request interrupted.");
            }
        }

        @Override
        public boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

