/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.OperationAccountant;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import java.io.IOException;
import java.util.List;

public class AsyncExecutor {
    protected static final Logger LOG = new Logger(AsyncExecutor.class);
    protected static AsyncCall<MutateRowRequest, MutateRowResponse> MUTATE_ROW_ASYNC = new AsyncCall<MutateRowRequest, MutateRowResponse>(){

        @Override
        public ListenableFuture<MutateRowResponse> call(BigtableDataClient client, MutateRowRequest request) {
            return client.mutateRowAsync(request);
        }
    };
    protected static AsyncCall<MutateRowsRequest, List<MutateRowsResponse>> MUTATE_ROWS_ASYNC = new AsyncCall<MutateRowsRequest, List<MutateRowsResponse>>(){

        @Override
        public ListenableFuture<List<MutateRowsResponse>> call(BigtableDataClient client, MutateRowsRequest request) {
            return client.mutateRowsAsync(request);
        }
    };
    protected static AsyncCall<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> READ_MODIFY_WRITE_ASYNC = new AsyncCall<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse>(){

        @Override
        public ListenableFuture<ReadModifyWriteRowResponse> call(BigtableDataClient client, ReadModifyWriteRowRequest request) {
            return client.readModifyWriteRowAsync(request);
        }
    };
    protected static AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse> CHECK_AND_MUTATE_ASYNC = new AsyncCall<CheckAndMutateRowRequest, CheckAndMutateRowResponse>(){

        @Override
        public ListenableFuture<CheckAndMutateRowResponse> call(BigtableDataClient client, CheckAndMutateRowRequest request) {
            return client.checkAndMutateRowAsync(request);
        }
    };
    protected static AsyncCall<ReadRowsRequest, List<Row>> READ_ROWS_ASYNC = new AsyncCall<ReadRowsRequest, List<Row>>(){

        @Override
        public ListenableFuture<List<Row>> call(BigtableDataClient client, ReadRowsRequest request) {
            return client.readRowsAsync(request);
        }
    };
    protected static AsyncCall<ReadRowsRequest, List<FlatRow>> READ_FLAT_ROWS_ASYNC = new AsyncCall<ReadRowsRequest, List<FlatRow>>(){

        @Override
        public ListenableFuture<List<FlatRow>> call(BigtableDataClient client, ReadRowsRequest request) {
            return client.readFlatRowsAsync(request);
        }
    };
    private final BigtableDataClient client;
    private final OperationAccountant operationsAccountant;

    public AsyncExecutor(BigtableDataClient client) {
        this(client, new OperationAccountant());
    }

    @VisibleForTesting
    AsyncExecutor(BigtableDataClient client, OperationAccountant operationAccountant) {
        this.client = client;
        this.operationsAccountant = operationAccountant;
    }

    public ListenableFuture<MutateRowResponse> mutateRowAsync(MutateRowRequest request) throws InterruptedException {
        return this.call(MUTATE_ROW_ASYNC, request);
    }

    public ListenableFuture<List<MutateRowsResponse>> mutateRowsAsync(MutateRowsRequest request) throws InterruptedException {
        return this.call(MUTATE_ROWS_ASYNC, request);
    }

    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) throws InterruptedException {
        return this.call(CHECK_AND_MUTATE_ASYNC, request);
    }

    public ListenableFuture<ReadModifyWriteRowResponse> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) throws InterruptedException {
        return this.call(READ_MODIFY_WRITE_ASYNC, request);
    }

    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) throws InterruptedException {
        return this.call(READ_ROWS_ASYNC, request);
    }

    public ListenableFuture<List<FlatRow>> readFlatRowsAsync(ReadRowsRequest request) throws InterruptedException {
        return this.call(READ_FLAT_ROWS_ASYNC, request);
    }

    private <RequestT extends MessageLite, ResponseT> ListenableFuture<ResponseT> call(AsyncCall<RequestT, ResponseT> rpc, RequestT request) {
        ListenableFuture<Object> future;
        try {
            future = rpc.call(this.client, request);
        }
        catch (Throwable e) {
            future = Futures.immediateFailedFuture(e);
        }
        this.operationsAccountant.registerOperation(future);
        return future;
    }

    public void flush() throws IOException {
        LOG.trace("Flushing", new Object[0]);
        try {
            this.operationsAccountant.awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Batch operations were interrupted.");
        }
        LOG.trace("Done flushing", new Object[0]);
    }

    public boolean hasInflightRequests() {
        return this.operationsAccountant.hasInflightOperations();
    }

    public BigtableDataClient getClient() {
        return this.client;
    }

    public OperationAccountant getOperationAccountant() {
        return this.operationsAccountant;
    }

    protected static interface AsyncCall<RequestT, ResponseT> {
        public ListenableFuture<ResponseT> call(BigtableDataClient var1, RequestT var2);
    }
}

