/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;

public interface BigtableAsyncUtilities {
    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(MethodDescriptor<RequestT, ResponseT> var1, Predicate<RequestT> var2);

    public static class Default
    implements BigtableAsyncUtilities {
        private static final Logger LOG = new Logger(BigtableAsyncUtilities.class);
        private final Channel channel;

        public Default(Channel channel) {
            this.channel = channel;
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(final MethodDescriptor<RequestT, ResponseT> method, final Predicate<RequestT> isRetryable) {
            final BigtableAsyncRpc.RpcMetrics metrics = BigtableAsyncRpc.RpcMetrics.createRpcMetrics(method);
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public boolean isRetryable(RequestT request) {
                    return isRetryable.apply(request);
                }

                @Override
                public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                    return method;
                }

                @Override
                public BigtableAsyncRpc.RpcMetrics getRpcMetrics() {
                    return metrics;
                }

                @Override
                public ClientCall<RequestT, ResponseT> newCall(CallOptions callOptions) {
                    return Default.this.channel.newCall(method, callOptions);
                }

                @Override
                public void start(RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata, ClientCall<RequestT, ResponseT> call) {
                    call.start(listener, metadata);
                    call.request(1);
                    try {
                        call.sendMessage(request);
                    }
                    catch (Throwable t) {
                        LOG.error("Could not sendMessage()", t, new Object[0]);
                        call.cancel("Exception in sendMessage.", t);
                        throw Throwables.propagate(t);
                    }
                    try {
                        call.halfClose();
                    }
                    catch (Throwable t) {
                        LOG.error("Could not halfClose()", t, new Object[0]);
                        call.cancel("Exception in halfClose.", t);
                        throw Throwables.propagate(t);
                    }
                }
            };
        }
    }
}

