/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.HashMultimap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.Iterables;
import com.google.bigtable.repackaged.com.google.common.collect.Multimap;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class BulkRead {
    protected static final Logger LOG = new Logger(BulkRead.class);
    private static final Comparator<Map.Entry<ByteString, SettableFuture<FlatRow>>> ENTRY_SORTER = new Comparator<Map.Entry<ByteString, SettableFuture<FlatRow>>>(){

        @Override
        public int compare(Map.Entry<ByteString, SettableFuture<FlatRow>> o1, Map.Entry<ByteString, SettableFuture<FlatRow>> o2) {
            return ByteStringComparator.INSTANCE.compare(o1.getKey(), o2.getKey());
        }
    };
    private final BigtableDataClient client;
    private final int batchSizes;
    private final ExecutorService threadPool;
    private final String tableName;
    private final Map<RowFilter, Batch> batches;

    public BulkRead(BigtableDataClient client, BigtableTableName tableName, int batchSizes, ExecutorService threadPool) {
        this.client = client;
        this.tableName = tableName.toString();
        this.batchSizes = batchSizes;
        this.threadPool = threadPool;
        this.batches = new HashMap<RowFilter, Batch>();
    }

    public ListenableFuture<FlatRow> add(ReadRowsRequest request) {
        Preconditions.checkNotNull(request);
        Preconditions.checkArgument(request.getRows().getRowKeysCount() == 1);
        ByteString rowKey = request.getRows().getRowKeysList().get(0);
        Preconditions.checkArgument(!rowKey.equals(ByteString.EMPTY));
        RowFilter filter = request.getFilter();
        Batch batch = this.batches.get(filter);
        if (batch == null) {
            batch = new Batch(filter);
            this.batches.put(filter, batch);
        }
        return batch.addKey(rowKey);
    }

    public void flush() {
        for (Batch batch : this.batches.values()) {
            Collection<Batch> subbatches = batch.split();
            for (Batch miniBatch : subbatches) {
                this.threadPool.submit(miniBatch);
            }
        }
        this.batches.clear();
    }

    public int getBatchSizes() {
        return this.batchSizes;
    }

    class Batch
    implements Runnable {
        private final RowFilter filter;
        private final Multimap<ByteString, SettableFuture<FlatRow>> futures;

        public Batch(RowFilter filter) {
            this.filter = filter;
            this.futures = HashMultimap.create();
        }

        public Collection<Batch> split() {
            if (this.futures.values().size() <= BulkRead.this.batchSizes) {
                return ImmutableList.of(this);
            }
            ArrayList<Map.Entry<ByteString, SettableFuture<FlatRow>>> toSplit = new ArrayList<Map.Entry<ByteString, SettableFuture<FlatRow>>>(this.futures.entries());
            Collections.sort(toSplit, ENTRY_SORTER);
            ArrayList<Batch> batches = new ArrayList<Batch>();
            for (List<Map.Entry<ByteString, SettableFuture<FlatRow>>> entries : Iterables.partition(toSplit, BulkRead.this.batchSizes)) {
                Batch batch = new Batch(this.filter);
                for (Map.Entry<ByteString, SettableFuture<FlatRow>> entry : entries) {
                    batch.futures.put(entry.getKey(), entry.getValue());
                }
                batches.add(batch);
            }
            return batches;
        }

        public SettableFuture<FlatRow> addKey(ByteString rowKey) {
            SettableFuture<FlatRow> future = SettableFuture.create();
            this.futures.put(rowKey, future);
            return future;
        }

        @Override
        public void run() {
            try {
                FlatRow row;
                ResultScanner<FlatRow> scanner = BulkRead.this.client.readFlatRows(ReadRowsRequest.newBuilder().setTableName(BulkRead.this.tableName).setFilter(this.filter).setRows(RowSet.newBuilder().addAllRowKeys(this.futures.keys()).build()).build());
                while ((row = scanner.next()) != null) {
                    Collection<SettableFuture<FlatRow>> rowFutures = this.futures.get(row.getRowKey());
                    if (rowFutures != null) {
                        for (SettableFuture<FlatRow> rowFuture : rowFutures) {
                            rowFuture.set(row);
                        }
                        this.futures.removeAll(row.getRowKey());
                        continue;
                    }
                    LOG.warn("Found key: %s, but it was not in the original request.", row.getRowKey());
                }
                for (Map.Entry<ByteString, SettableFuture<FlatRow>> entry : this.futures.entries()) {
                    entry.getValue().set(null);
                }
            }
            catch (Throwable e) {
                for (Map.Entry<ByteString, SettableFuture<FlatRow>> entry : this.futures.entries()) {
                    entry.getValue().setException(e);
                }
            }
        }
    }
}

