/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class RetryingMutateRowsOperation
extends AbstractRetryingOperation<MutateRowsRequest, MutateRowsResponse, List<MutateRowsResponse>> {
    private static final Status INVALID_RESPONSE = Status.INTERNAL.withDescription("The server returned an invalid response");
    private static final com.google.bigtable.repackaged.com.google.rpc.Status STATUS_INTERNAL = com.google.bigtable.repackaged.com.google.rpc.Status.newBuilder().setCode(Status.Code.INTERNAL.value()).build();
    private MutateRowsRequest currentRequest;
    private int[] mapToOriginalIndex;
    private final com.google.bigtable.repackaged.com.google.rpc.Status[] results;
    private boolean messageIsInvalid;

    private static Status.Code getGrpcCode(com.google.bigtable.repackaged.com.google.rpc.Status status) {
        return status == null ? null : Status.fromCodeValue(status.getCode()).getCode();
    }

    private static MutateRowsResponse.Entry createEntry(int i, com.google.bigtable.repackaged.com.google.rpc.Status status) {
        return MutateRowsResponse.Entry.newBuilder().setIndex(i).setStatus(status).build();
    }

    public RetryingMutateRowsOperation(RetryOptions retryOptions, MutateRowsRequest originalRquest, BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> retryableRpc, CallOptions callOptions, ScheduledExecutorService retryExecutorService, Metadata originalMetadata) {
        super(retryOptions, originalRquest, retryableRpc, callOptions, retryExecutorService, originalMetadata);
        this.currentRequest = originalRquest;
        this.results = new com.google.bigtable.repackaged.com.google.rpc.Status[originalRquest.getEntriesCount()];
        this.mapToOriginalIndex = new int[originalRquest.getEntriesCount()];
        for (int i = 0; i < this.mapToOriginalIndex.length; ++i) {
            this.mapToOriginalIndex[i] = i;
        }
    }

    @Override
    public void onMessage(MutateRowsResponse message) {
        for (MutateRowsResponse.Entry entry : message.getEntriesList()) {
            int index = (int)entry.getIndex();
            if (index >= this.mapToOriginalIndex.length || index < 0) {
                this.messageIsInvalid = true;
                break;
            }
            this.results[this.mapToOriginalIndex[index]] = entry.getStatus();
        }
    }

    @Override
    protected MutateRowsRequest getRetryRequest() {
        return this.currentRequest;
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i] != null) continue;
            this.messageIsInvalid = true;
            break;
        }
        if (this.messageIsInvalid) {
            this.onError(INVALID_RESPONSE, trailers);
            return false;
        }
        boolean fail = false;
        ArrayList<Integer> toRetry = new ArrayList<Integer>();
        for (int i = 0; i < this.results.length; ++i) {
            com.google.bigtable.repackaged.com.google.rpc.Status status = this.results[i];
            if (status.getCode() == Status.Code.OK.value()) continue;
            if (this.retryOptions.isRetryable(RetryingMutateRowsOperation.getGrpcCode(status))) {
                toRetry.add(i);
                continue;
            }
            fail = true;
        }
        if (fail) {
            this.rpc.getRpcMetrics().markFailure();
        }
        if (toRetry.isEmpty() || fail) {
            this.completionFuture.set(Arrays.asList(this.buildResponse()));
            return true;
        }
        long nextBackOff = this.getNextBackoff();
        if (nextBackOff == -1L) {
            this.rpc.getRpcMetrics().markRetriesExhasted();
            this.completionFuture.set(Arrays.asList(this.buildResponse()));
            return true;
        }
        this.currentRequest = this.createRetryRequest(toRetry);
        this.mapToOriginalIndex = this.toIntArray(toRetry);
        this.performRetry(nextBackOff);
        return false;
    }

    private MutateRowsRequest createRetryRequest(List<Integer> indiciesToRetry) {
        MutateRowsRequest originalRequest = (MutateRowsRequest)this.getOriginalRequest();
        MutateRowsRequest.Builder updatedRequest = MutateRowsRequest.newBuilder().setTableName(originalRequest.getTableName());
        for (int i = 0; i < indiciesToRetry.size(); ++i) {
            updatedRequest.addEntries(originalRequest.getEntries(indiciesToRetry.get(i)));
        }
        return updatedRequest.build();
    }

    private int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private MutateRowsResponse buildResponse() {
        ArrayList<MutateRowsResponse.Entry> entries = new ArrayList<MutateRowsResponse.Entry>();
        for (int i = 0; i < this.results.length; ++i) {
            com.google.bigtable.repackaged.com.google.rpc.Status status = this.results[i] == null ? STATUS_INTERNAL : this.results[i];
            entries.add(RetryingMutateRowsOperation.createEntry(i, status));
        }
        return MutateRowsResponse.newBuilder().addAllEntries(entries).build();
    }
}

