/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;

public class ThrottlingClientInterceptor
implements ClientInterceptor {
    private final ResourceLimiter resourceLimiter;

    public ThrottlingClientInterceptor(ResourceLimiter resourceLimiter) {
        Preconditions.checkNotNull(resourceLimiter);
        this.resourceLimiter = resourceLimiter;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel delegateChannel) {
        if (this.resourceLimiter == null) {
            return delegateChannel.newCall(method, callOptions);
        }
        return new ForwardingClientCall<ReqT, RespT>(){
            private ClientCall.Listener<RespT> delegateListener = null;
            private ClientCall<ReqT, RespT> delegateCall;
            private Metadata headers;
            private int numMessagesRequested = 0;
            private Long id = null;

            @Override
            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                this.delegateListener = listener;
                this.headers = headers;
            }

            @Override
            public void request(int numMessages) {
                if (this.id == null) {
                    this.numMessagesRequested += numMessages;
                } else {
                    this.delegate().request(numMessages);
                }
            }

            @Override
            public void sendMessage(ReqT message) {
                Preconditions.checkState(this.delegateCall == null, "ThrottlingClientInterceptor only supports unary operations");
                Preconditions.checkState(this.id == null, "ThrottlingClientInterceptor only supports unary operations");
                Preconditions.checkState(this.delegateListener != null, "start() has to be called before sendMessage().");
                Preconditions.checkState(this.headers != null, "start() has to be called before sendMessage().");
                try {
                    this.id = ThrottlingClientInterceptor.this.resourceLimiter.registerOperationWithHeapSize(((MessageLite)message).getSerializedSize());
                }
                catch (InterruptedException e) {
                    this.delegateListener.onClose(Status.INTERNAL.withDescription("Operation was interrupted"), new Metadata());
                    return;
                }
                this.delegateCall = delegateChannel.newCall(method, callOptions);
                ForwardingClientCallListener.SimpleForwardingClientCallListener markCompletionListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(this.delegateListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        ThrottlingClientInterceptor.this.resourceLimiter.markCanBeCompleted(id);
                        this.delegate().onClose(status, trailers);
                    }
                };
                this.delegate().start(markCompletionListener, this.headers);
                this.delegate().request(this.numMessagesRequested);
                this.delegate().sendMessage(message);
            }

            @Override
            protected ClientCall<ReqT, RespT> delegate() {
                return this.delegateCall;
            }
        };
    }
}

