/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.StatusException;

public class GoogleCloudResourcePrefixInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> GRPC_RESOURCE_PREFIX_KEY = Metadata.Key.of("google-cloud-resource-prefix", Metadata.ASCII_STRING_MARSHALLER);
    private final String defaultValue;

    public GoogleCloudResourcePrefixInterceptor(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws StatusException {
                GoogleCloudResourcePrefixInterceptor.this.updateHeaders(headers);
                this.delegate().start(responseListener, headers);
            }
        };
    }

    @VisibleForTesting
    public void updateHeaders(Metadata headers) {
        if (!headers.containsKey(GRPC_RESOURCE_PREFIX_KEY)) {
            headers.put(GRPC_RESOURCE_PREFIX_KEY, this.defaultValue);
        }
    }
}

