/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicInteger;

public class OutstandingRequestCountListener<ResponseT>
extends ClientCall.Listener<ResponseT> {
    private StreamObserver<ResponseT> observer;
    private AtomicInteger outstandingRequestCount;

    public OutstandingRequestCountListener(StreamObserver<ResponseT> observer, AtomicInteger outstandingRequestCount) {
        this.outstandingRequestCount = outstandingRequestCount;
        this.observer = observer;
    }

    @Override
    public void onMessage(ResponseT response) {
        this.outstandingRequestCount.decrementAndGet();
        this.observer.onNext(response);
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            this.observer.onCompleted();
        } else {
            this.observer.onError(status.asRuntimeException());
        }
    }
}

