/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;

class ReadRowsRequestManager {
    private final ReadRowsRequest originalRequest;
    private long rowCount = 0L;
    private ByteString lastFoundKey;

    ReadRowsRequestManager(ReadRowsRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    void updateLastFoundKey(ByteString key) {
        this.lastFoundKey = key;
        ++this.rowCount;
    }

    ReadRowsRequest buildUpdatedRequest() {
        long numRowsLimit;
        ReadRowsRequest.Builder newRequest = ReadRowsRequest.newBuilder().setRows(this.filterRows()).setTableName(this.originalRequest.getTableName());
        if (this.originalRequest.hasFilter()) {
            newRequest.setFilter(this.originalRequest.getFilter());
        }
        if ((numRowsLimit = this.originalRequest.getRowsLimit()) > 0L) {
            Preconditions.checkArgument((numRowsLimit -= this.rowCount) > 0L, "The remaining number of rows must be greater than 0.");
            newRequest.setRowsLimit(numRowsLimit);
        }
        return newRequest.build();
    }

    private RowSet filterRows() {
        RowSet originalRows = this.originalRequest.getRows();
        if (this.lastFoundKey == null) {
            return originalRows;
        }
        RowSet.Builder rowSetBuilder = RowSet.newBuilder();
        for (ByteString key : originalRows.getRowKeysList()) {
            if (this.startKeyIsAlreadyRead(key)) continue;
            rowSetBuilder.addRowKeys(key);
        }
        for (RowRange rowRange : originalRows.getRowRangesList()) {
            RowRange.EndKeyCase endKeyCase = rowRange.getEndKeyCase();
            if (endKeyCase == RowRange.EndKeyCase.END_KEY_CLOSED && this.endKeyIsAlreadyRead(rowRange.getEndKeyClosed()) || endKeyCase == RowRange.EndKeyCase.END_KEY_OPEN && this.endKeyIsAlreadyRead(rowRange.getEndKeyOpen())) continue;
            RowRange newRange = rowRange;
            RowRange.StartKeyCase startKeyCase = rowRange.getStartKeyCase();
            if (startKeyCase == RowRange.StartKeyCase.START_KEY_CLOSED && this.startKeyIsAlreadyRead(rowRange.getStartKeyClosed()) || startKeyCase == RowRange.StartKeyCase.START_KEY_OPEN && this.startKeyIsAlreadyRead(rowRange.getStartKeyOpen()) || startKeyCase == RowRange.StartKeyCase.STARTKEY_NOT_SET) {
                newRange = rowRange.toBuilder().setStartKeyOpen(this.lastFoundKey).build();
            }
            rowSetBuilder.addRowRanges(newRange);
        }
        return rowSetBuilder.build();
    }

    private boolean startKeyIsAlreadyRead(ByteString startKey) {
        return this.lastFoundKey != null && (startKey.isEmpty() || ByteStringComparator.INSTANCE.compare(startKey, this.lastFoundKey) <= 0);
    }

    private boolean endKeyIsAlreadyRead(ByteString endKey) {
        return this.lastFoundKey != null && !endKey.isEmpty() && ByteStringComparator.INSTANCE.compare(endKey, this.lastFoundKey) <= 0;
    }
}

