/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.IOExceptionWithStatus;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.io.IOException;
import java.util.Objects;

abstract class ResultQueueEntry<T> {
    private static final ResultQueueEntry COMPLETION_ENTRY = new ResultQueueEntry(Type.CompletionMarker){

        public Object getResponseOrThrow() throws IOException {
            throw new IOException("Attempt to interpret a result stream completion marker as a result");
        }

        public boolean equals(Object obj) {
            return this.toResultQueueEntryForEquals(obj) != null;
        }
    };
    private static final ResultQueueEntry REQUEST_RESULT_ENTRY = new ResultQueueEntry(Type.RequestResultMarker){

        public Object getResponseOrThrow() throws IOException {
            throw new IOException("Attempt to interpret a result marker as a result");
        }

        public boolean equals(Object obj) {
            return this.toResultQueueEntryForEquals(obj) != null;
        }
    };
    protected final Type type;

    public static <T> ResultQueueEntry<T> fromResponse(T response) {
        Preconditions.checkArgument(response != null, "Response may not be null");
        return new ResponseResultQueueEntry(response);
    }

    public static <T> ResultQueueEntry<T> fromThrowable(Throwable throwable) {
        Preconditions.checkArgument(throwable != null, "Throwable may not be null");
        return new ExceptionResultQueueEntry(throwable);
    }

    public static <T> ResultQueueEntry<T> completionMarker() {
        return COMPLETION_ENTRY;
    }

    public static <T> ResultQueueEntry<T> requestResultMarker() {
        return REQUEST_RESULT_ENTRY;
    }

    public ResultQueueEntry(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public abstract T getResponseOrThrow() throws IOException;

    protected ResultQueueEntry<T> toResultQueueEntryForEquals(Object obj) {
        if (!(obj instanceof ResultQueueEntry) || obj == null) {
            return null;
        }
        ResultQueueEntry other = (ResultQueueEntry)obj;
        return this.type == other.type && this.getClass() == other.getClass() ? other : null;
    }

    private static final class ResponseResultQueueEntry<T>
    extends ResultQueueEntry<T> {
        private final T response;

        private ResponseResultQueueEntry(T response) {
            super(Type.Data);
            this.response = response;
        }

        @Override
        public T getResponseOrThrow() throws IOException {
            return this.response;
        }

        public boolean equals(Object obj) {
            ResponseResultQueueEntry other = (ResponseResultQueueEntry)this.toResultQueueEntryForEquals(obj);
            return other != null && Objects.equals(this.response, other.response);
        }
    }

    private static final class ExceptionResultQueueEntry<T>
    extends ResultQueueEntry<T> {
        private static final String EXCEPTION_MESSAGE = "Error in response stream";
        private final Throwable throwable;

        private ExceptionResultQueueEntry(Throwable throwable) {
            super(Type.Exception);
            this.throwable = throwable;
        }

        @Override
        public T getResponseOrThrow() throws IOException {
            throw new IOExceptionWithStatus(EXCEPTION_MESSAGE, this.throwable, Status.fromThrowable(this.throwable));
        }

        public boolean equals(Object obj) {
            ExceptionResultQueueEntry other = (ExceptionResultQueueEntry)this.toResultQueueEntryForEquals(obj);
            return other != null && Objects.equals(this.throwable, other.throwable);
        }
    }

    public static enum Type {
        Data,
        Exception,
        CompletionMarker,
        RequestResultMarker;

    }
}

