/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResponseQueueReader;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResumingStreamingResultScanner
implements ResultScanner<FlatRow> {
    private static final Meter resultsMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "scanner.results");
    private static final Timer resultsTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Debug, "scanner.results.latency");
    private final ScanHandler scanHandler;
    private final ResponseQueueReader responseQueueReader;

    public ResumingStreamingResultScanner(ResponseQueueReader responseQueueReader, ScanHandler scanHandler) {
        this.responseQueueReader = responseQueueReader;
        this.scanHandler = scanHandler;
    }

    public final FlatRow[] next(int count) throws IOException {
        FlatRow row;
        ArrayList<FlatRow> resultList = new ArrayList<FlatRow>(count);
        for (int i = 0; i < count && (row = this.next()) != null; ++i) {
            resultList.add(row);
        }
        return resultList.toArray(new FlatRow[resultList.size()]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FlatRow next() throws IOException {
        Timer.Context ignored = resultsTimer.time();
        Throwable throwable = null;
        while (true) {
            try {
                FlatRow result = this.responseQueueReader.getNextMergedRow();
                if (result != null) {
                    resultsMeter.mark();
                }
                FlatRow flatRow = result;
                return flatRow;
            }
            catch (ScanTimeoutException rte) {
                try {
                    this.scanHandler.handleTimeout(rte);
                    continue;
                    catch (Throwable e) {
                        this.scanHandler.cancel();
                        throw new BigtableRetriesExhaustedException("Exhausted streaming retries.", e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            break;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public int available() {
        return this.responseQueueReader.available();
    }

    @Override
    public void close() throws IOException {
        this.scanHandler.cancel();
    }
}

