/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.common;

import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Provider {
    private static final Logger logger = Logger.getLogger(Provider.class.getName());

    @Nullable
    public static <T> T newInstance(String name, @Nullable T defaultValue) {
        try {
            Class<?> provider = Class.forName(name);
            Object result = provider.getConstructor(new Class[0]).newInstance(new Object[0]);
            logger.fine("Loaded: " + name);
            return (T)result;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Falling back to " + defaultValue, e);
            return defaultValue;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(Class<?> rawClass, Class<T> superclass) {
        try {
            return rawClass.asSubclass(superclass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceConfigurationError("Provider " + rawClass.getName() + " could not be instantiated.", e);
        }
    }

    public static <T> ClassLoader getCorrectClassLoader(Class<T> superClass) {
        if (Provider.isAndroid()) {
            return superClass.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

