/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BucketBoundaries {
    private final List<Double> bucketBoundaries;

    public static final BucketBoundaries create(List<Double> bucketBoundaries) {
        Preconditions.checkNotNull(bucketBoundaries, "bucketBoundaries list should not be null.");
        ArrayList<Double> bucketBoundariesCopy = new ArrayList<Double>(bucketBoundaries);
        Preconditions.checkArgument(!bucketBoundariesCopy.isEmpty(), "Zero length bucket boundaries");
        double lower = (Double)bucketBoundariesCopy.get(0);
        for (int i = 1; i < bucketBoundariesCopy.size(); ++i) {
            double next = (Double)bucketBoundariesCopy.get(i);
            Preconditions.checkArgument(lower < next, "Bucket boundaries not sorted.");
            lower = next;
        }
        return new BucketBoundaries(Collections.unmodifiableList(bucketBoundariesCopy));
    }

    public final List<Double> getBoundaries() {
        return this.bucketBoundaries;
    }

    private BucketBoundaries(List<Double> bucketBoundaries) {
        this.bucketBoundaries = bucketBoundaries;
    }
}

