/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.instrumentation.common.NonThrowingCloseable;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.StatsContext;
import com.google.bigtable.repackaged.io.grpc.Context;

public final class ContextUtils {
    public static final Context.Key<StatsContext> STATS_CONTEXT_KEY = Context.key("instrumentation-stats-key");

    private ContextUtils() {
    }

    static StatsContext getCurrentStatsContext() {
        return STATS_CONTEXT_KEY.get(Context.current());
    }

    static NonThrowingCloseable withStatsContext(StatsContext statsContext) {
        return new WithStatsContext(statsContext, STATS_CONTEXT_KEY);
    }

    private static final class WithStatsContext
    implements NonThrowingCloseable {
        private final Context origContext;

        private WithStatsContext(StatsContext statsContext, Context.Key<StatsContext> contextKey) {
            this.origContext = Context.current().withValue(contextKey, statsContext).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
        }
    }
}

