/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.instrumentation.common.Function;
import com.google.bigtable.repackaged.com.google.instrumentation.common.Timestamp;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.DistributionAggregation;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.IntervalAggregation;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.ViewDescriptor;
import java.util.List;

public abstract class View {
    public abstract ViewDescriptor getViewDescriptor();

    public abstract <T> T match(Function<DistributionView, T> var1, Function<IntervalView, T> var2);

    private View() {
    }

    public static final class IntervalView
    extends View {
        private final ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor;
        private final List<IntervalAggregation> intervalAggregations;

        public static IntervalView create(ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor, List<IntervalAggregation> intervalAggregations) {
            return new IntervalView(intervalViewDescriptor, intervalAggregations);
        }

        public List<IntervalAggregation> getIntervalAggregations() {
            return this.intervalAggregations;
        }

        @Override
        public ViewDescriptor.IntervalViewDescriptor getViewDescriptor() {
            return this.intervalViewDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionView, T> p0, Function<IntervalView, T> p1) {
            return p1.apply(this);
        }

        private IntervalView(ViewDescriptor.IntervalViewDescriptor intervalViewDescriptor, List<IntervalAggregation> intervalAggregations) {
            this.intervalViewDescriptor = intervalViewDescriptor;
            this.intervalAggregations = intervalAggregations;
        }
    }

    public static final class DistributionView
    extends View {
        private final ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor;
        private final List<DistributionAggregation> distributionAggregations;
        private final Timestamp start;
        private final Timestamp end;

        public static DistributionView create(ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor, List<DistributionAggregation> distributionAggregations, Timestamp start, Timestamp end) {
            return new DistributionView(distributionViewDescriptor, distributionAggregations, start, end);
        }

        public List<DistributionAggregation> getDistributionAggregations() {
            return this.distributionAggregations;
        }

        public Timestamp getStart() {
            return this.start;
        }

        public Timestamp getEnd() {
            return this.end;
        }

        @Override
        public ViewDescriptor.DistributionViewDescriptor getViewDescriptor() {
            return this.distributionViewDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionView, T> p0, Function<IntervalView, T> p1) {
            return p0.apply(this);
        }

        private DistributionView(ViewDescriptor.DistributionViewDescriptor distributionViewDescriptor, List<DistributionAggregation> distributionAggregations, Timestamp start, Timestamp end) {
            this.distributionViewDescriptor = distributionViewDescriptor;
            this.distributionAggregations = distributionAggregations;
            this.start = start;
            this.end = end;
        }
    }
}

