/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.AttributeValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Annotation {
    private static final Map<String, AttributeValue> EMPTY_ATTRIBUTES = Collections.emptyMap();
    private final String description;
    private final Map<String, AttributeValue> attributes;

    public static Annotation fromDescription(String description) {
        return new Annotation(description, EMPTY_ATTRIBUTES);
    }

    public static Annotation fromDescriptionAndAttributes(String description, Map<String, AttributeValue> attributes) {
        return new Annotation(description, attributes);
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, AttributeValue> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation that = (Annotation)obj;
        return Objects.equal(this.description, that.description) && Objects.equal(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode(this.description, this.attributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("description", this.description).add("attributes", this.attributes).toString();
    }

    private Annotation(String description, Map<String, AttributeValue> attributes) {
        this.description = Preconditions.checkNotNull(description, "description");
        this.attributes = Collections.unmodifiableMap(new HashMap<String, AttributeValue>(Preconditions.checkNotNull(attributes, "attributes")));
    }
}

