/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AttributeValue {
    private final String stringValue;
    private final Boolean booleanValue;
    private final Long longValue;

    public static AttributeValue stringAttributeValue(String stringValue) {
        return new AttributeValue(Preconditions.checkNotNull(stringValue, "stringValue"), null, null);
    }

    public static AttributeValue booleanAttributeValue(boolean booleanValue) {
        return new AttributeValue(null, booleanValue, null);
    }

    public static AttributeValue longAttributeValue(long longValue) {
        return new AttributeValue(null, null, longValue);
    }

    private AttributeValue(@Nullable String stringValue, @Nullable Boolean booleanValue, @Nullable Long longValue) {
        this.stringValue = stringValue;
        this.booleanValue = booleanValue;
        this.longValue = longValue;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    @Nullable
    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    @Nullable
    public Long getLongValue() {
        return this.longValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue that = (AttributeValue)obj;
        return Objects.equal(this.stringValue, that.stringValue) && Objects.equal(this.booleanValue, that.booleanValue) && Objects.equal(this.longValue, that.longValue);
    }

    public int hashCode() {
        return Objects.hashCode(this.stringValue, this.booleanValue, this.longValue);
    }

    public String toString() {
        if (this.getStringValue() != null) {
            return MoreObjects.toStringHelper(this).add("type", "string").add("value", this.getStringValue()).toString();
        }
        if (this.getBooleanValue() != null) {
            return MoreObjects.toStringHelper(this).add("type", "boolean").add("value", this.getBooleanValue()).toString();
        }
        if (this.getLongValue() != null) {
            return MoreObjects.toStringHelper(this).add("type", "long").add("value", this.getLongValue()).toString();
        }
        throw new RuntimeException("Not a supported attribute value");
    }
}

