/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanContext;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanId;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.TraceId;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Link {
    private final TraceId traceId;
    private final SpanId spanId;
    private final Type type;

    public static Link fromSpanContext(SpanContext context, Type type) {
        return new Link(context.getTraceId(), context.getSpanId(), type);
    }

    public TraceId getTraceId() {
        return this.traceId;
    }

    public SpanId getSpanId() {
        return this.spanId;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        return Objects.equal(this.traceId, that.traceId) && Objects.equal(this.spanId, that.spanId) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.traceId, this.spanId, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("traceId", this.traceId).add("spanId", this.spanId).add("type", (Object)this.type).toString();
    }

    private Link(TraceId traceId, SpanId spanId, Type type) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.type = type;
    }

    public static enum Type {
        CHILD,
        PARENT;

    }
}

