/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.instrumentation.common.NonThrowingCloseable;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.BlankSpan;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.ContextUtils;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.Span;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanBuilder;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanContext;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanFactory;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.StartSpanOptions;
import javax.annotation.Nullable;

public abstract class Tracer {
    private static final NoopTracer noopTracer = new NoopTracer();
    private final SpanFactory spanFactory;

    static Tracer getNoopTracer() {
        return noopTracer;
    }

    public final Span getCurrentSpan() {
        Span currentSpan = ContextUtils.getCurrentSpan();
        return currentSpan != null ? currentSpan : BlankSpan.INSTANCE;
    }

    public final NonThrowingCloseable withSpan(Span span) {
        return ContextUtils.withSpan(Preconditions.checkNotNull(span, "span"));
    }

    public final SpanBuilder spanBuilder(String name) {
        return this.spanBuilder(ContextUtils.getCurrentSpan(), name);
    }

    public final SpanBuilder spanBuilder(@Nullable Span parent, String name) {
        return SpanBuilder.builder(this.spanFactory, parent, Preconditions.checkNotNull(name, "name"));
    }

    public final SpanBuilder spanBuilderWithRemoteParent(@Nullable SpanContext remoteParent, String name) {
        return SpanBuilder.builderWithRemoteParent(this.spanFactory, remoteParent, Preconditions.checkNotNull(name, "name"));
    }

    protected Tracer(SpanFactory spanFactory) {
        this.spanFactory = Preconditions.checkNotNull(spanFactory, "spanFactory");
    }

    private static final class NoopTracer
    extends Tracer {
        private NoopTracer() {
            super(new NoopSpanFactory());
        }

        private static final class NoopSpanFactory
        extends SpanFactory {
            private NoopSpanFactory() {
            }

            @Override
            protected Span startSpan(@Nullable Span parent, String name, StartSpanOptions options) {
                return BlankSpan.INSTANCE;
            }

            @Override
            protected Span startSpanWithRemoteParent(@Nullable SpanContext remoteParent, String name, StartSpanOptions options) {
                return BlankSpan.INSTANCE;
            }
        }
    }
}

