/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.instrumentation.common.Provider;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.BinaryPropagationHandler;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.TraceComponent;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.Tracer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tracing {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static final TraceComponent traceComponent = Tracing.loadTraceComponent(Provider.getCorrectClassLoader(TraceComponent.class));

    public static Tracer getTracer() {
        return traceComponent.getTracer();
    }

    public static BinaryPropagationHandler getBinaryPropagationHandler() {
        return traceComponent.getBinaryPropagationHandler();
    }

    @VisibleForTesting
    static TraceComponent loadTraceComponent(ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("com.google.bigtable.repackaged.com.google.instrumentation.trace.TraceComponentImpl", true, classLoader), TraceComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Using default implementation for TraceComponent.", e);
            return TraceComponent.getNoopTraceComponent();
        }
    }

    private Tracing() {
    }
}

