/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class ServiceDescriptor {
    private final String name;
    private final Collection<MethodDescriptor<?, ?>> methods;
    private final Object schemaDescriptor;

    public ServiceDescriptor(String name, MethodDescriptor<?, ?> ... methods) {
        this(name, Arrays.asList(methods));
    }

    public ServiceDescriptor(String name, Collection<MethodDescriptor<?, ?>> methods) {
        this(ServiceDescriptor.newBuilder(name).addAllMethods(Preconditions.checkNotNull(methods, "methods")));
    }

    private ServiceDescriptor(Builder b) {
        this.name = b.name;
        ServiceDescriptor.validateMethodNames(this.name, b.methods);
        this.methods = Collections.unmodifiableList(new ArrayList(b.methods));
        this.schemaDescriptor = b.schemaDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MethodDescriptor<?, ?>> getMethods() {
        return this.methods;
    }

    @Nullable
    public Object getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    static void validateMethodNames(String serviceName, Collection<MethodDescriptor<?, ?>> methods) {
        HashSet<String> allNames = new HashSet<String>(methods.size());
        for (MethodDescriptor<?, ?> method : methods) {
            Preconditions.checkNotNull(method, "method");
            String methodServiceName = MethodDescriptor.extractFullServiceName(method.getFullMethodName());
            Preconditions.checkArgument(serviceName.equals(methodServiceName), "service names %s != %s", methodServiceName, serviceName);
            Preconditions.checkArgument(allNames.add(method.getFullMethodName()), "duplicate name %s", method.getFullMethodName());
        }
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private String name;
        private List<MethodDescriptor<?, ?>> methods = new ArrayList();
        private Object schemaDescriptor;

        private Builder(String name) {
            this.setName(name);
        }

        public Builder setName(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder addMethod(MethodDescriptor<?, ?> method) {
            this.methods.add(Preconditions.checkNotNull(method, "method"));
            return this;
        }

        private Builder addAllMethods(Collection<MethodDescriptor<?, ?>> methods) {
            this.methods.addAll(methods);
            return this;
        }

        public Builder setSchemaDescriptor(@Nullable Object schemaDescriptor) {
            this.schemaDescriptor = schemaDescriptor;
            return this;
        }

        public ServiceDescriptor build() {
            return new ServiceDescriptor(this);
        }
    }
}

