/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.io.grpc.Context;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadLocalContextStorage
extends Context.Storage {
    private static final Logger log = Logger.getLogger(ThreadLocalContextStorage.class.getName());
    private static final ThreadLocal<Context> localContext = new ThreadLocal();

    ThreadLocalContextStorage() {
    }

    @Override
    public void attach(Context toAttach) {
        localContext.set(toAttach);
    }

    @Override
    public void detach(Context toDetach, Context toRestore) {
        if (this.current() != toDetach) {
            log.log(Level.SEVERE, "Context was not attached when detaching", new Throwable().fillInStackTrace());
        }
        this.attach(toRestore);
    }

    @Override
    public Context current() {
        return localContext.get();
    }
}

