/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.Stats;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.StatsContextFactory;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.Tracing;
import com.google.bigtable.repackaged.io.grpc.BindableService;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.InternalNotifyOnServerBuild;
import com.google.bigtable.repackaged.io.grpc.Server;
import com.google.bigtable.repackaged.io.grpc.ServerBuilder;
import com.google.bigtable.repackaged.io.grpc.ServerInterceptor;
import com.google.bigtable.repackaged.io.grpc.ServerMethodDefinition;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.ServerTransportFilter;
import com.google.bigtable.repackaged.io.grpc.internal.CensusStatsModule;
import com.google.bigtable.repackaged.io.grpc.internal.CensusTracingModule;
import com.google.bigtable.repackaged.io.grpc.internal.FixedObjectPool;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.InternalHandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.internal.InternalServer;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.internal.ServerImpl;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourcePool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final ObjectPool<? extends Executor> DEFAULT_EXECUTOR_POOL = SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    private static final HandlerRegistry DEFAULT_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private static final DecompressorRegistry DEFAULT_DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry DEFAULT_COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    final List<ServerTransportFilter> transportFilters = new ArrayList<ServerTransportFilter>();
    final List<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    private final List<ServerStreamTracer.Factory> streamTracerFactories = new ArrayList<ServerStreamTracer.Factory>();
    HandlerRegistry fallbackRegistry = DEFAULT_FALLBACK_REGISTRY;
    ObjectPool<? extends Executor> executorPool = DEFAULT_EXECUTOR_POOL;
    DecompressorRegistry decompressorRegistry = DEFAULT_DECOMPRESSOR_REGISTRY;
    CompressorRegistry compressorRegistry = DEFAULT_COMPRESSOR_REGISTRY;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executorPool = executor != null ? new FixedObjectPool<Executor>(executor) : DEFAULT_EXECUTOR_POOL;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add(Preconditions.checkNotNull(filter, "filter"));
        return this.thisT();
    }

    @Override
    public final T intercept(ServerInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.streamTracerFactories.add(Preconditions.checkNotNull(factory, "factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry != null ? registry : DEFAULT_FALLBACK_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry != null ? registry : DEFAULT_DECOMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry != null ? registry : DEFAULT_COMPRESSOR_REGISTRY;
        return this.thisT();
    }

    @VisibleForTesting
    protected T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    @Override
    public Server build() {
        ServerImpl server = new ServerImpl(this, SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), this.buildTransportServer(Collections.unmodifiableList(this.getTracerFactories())), Context.ROOT);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    private List<ServerStreamTracer.Factory> getTracerFactories() {
        StatsContextFactory statsFactory;
        ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList<ServerStreamTracer.Factory>();
        StatsContextFactory statsContextFactory = statsFactory = this.statsFactory != null ? this.statsFactory : Stats.getStatsContextFactory();
        if (statsFactory != null) {
            CensusStatsModule censusStats = new CensusStatsModule(statsFactory, GrpcUtil.STOPWATCH_SUPPLIER, true);
            tracerFactories.add(censusStats.getServerTracerFactory());
        }
        CensusTracingModule censusTracing = new CensusTracingModule(Tracing.getTracer(), Tracing.getBinaryPropagationHandler());
        tracerFactories.add(censusTracing.getServerTracerFactory());
        tracerFactories.addAll(this.streamTracerFactories);
        return tracerFactories;
    }

    protected abstract InternalServer buildTransportServer(List<ServerStreamTracer.Factory> var1);

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

