/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SerializingExecutor
implements Executor,
Runnable {
    private static final Logger log = Logger.getLogger(SerializingExecutor.class.getName());
    private final Executor executor;
    private final Queue<Runnable> runQueue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean running = new AtomicBoolean();

    public SerializingExecutor(Executor executor) {
        Preconditions.checkNotNull(executor, "'executor' must not be null.");
        this.executor = executor;
    }

    @Override
    public void execute(Runnable r) {
        this.runQueue.add(Preconditions.checkNotNull(r, "'r' must not be null."));
        this.schedule(r);
    }

    private void schedule(@Nullable Runnable removable) {
        if (this.running.compareAndSet(false, true)) {
            boolean success = false;
            try {
                this.executor.execute(this);
                success = true;
            }
            finally {
                if (!success) {
                    if (removable != null) {
                        this.runQueue.remove(removable);
                    }
                    this.running.set(false);
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            Runnable r;
            while ((r = this.runQueue.poll()) != null) {
                try {
                    r.run();
                }
                catch (RuntimeException e) {
                    log.log(Level.SEVERE, "Exception while executing runnable " + r, e);
                }
            }
        }
        finally {
            this.running.set(false);
        }
        if (!this.runQueue.isEmpty()) {
            this.schedule(null);
        }
    }
}

