/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.internal.InternalServer;
import com.google.bigtable.repackaged.io.grpc.internal.ServerListener;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerTransport;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.netty.bootstrap.ServerBootstrap;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelInitializer;
import com.google.bigtable.repackaged.io.netty.channel.ChannelOption;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.ServerChannel;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.google.bigtable.repackaged.io.netty.util.AbstractReferenceCounted;
import com.google.bigtable.repackaged.io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServer
implements InternalServer {
    private static final Logger log = Logger.getLogger(InternalServer.class.getName());
    private final SocketAddress address;
    private final Class<? extends ServerChannel> channelType;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreamsPerConnection;
    private final boolean usingSharedBossGroup;
    private final boolean usingSharedWorkerGroup;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerListener listener;
    private Channel channel;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionIdleInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final boolean permitKeepAliveWithoutCalls;
    private final long permitKeepAliveTimeInNanos;
    private final ReferenceCounted eventLoopReferenceCounter = new EventLoopReferenceCounter();
    private final List<ServerStreamTracer.Factory> streamTracerFactories;

    NettyServer(SocketAddress address, Class<? extends ServerChannel> channelType, @Nullable EventLoopGroup bossGroup, @Nullable EventLoopGroup workerGroup, ProtocolNegotiator protocolNegotiator, List<ServerStreamTracer.Factory> streamTracerFactories, int maxStreamsPerConnection, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionIdleInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        this.address = address;
        this.channelType = Preconditions.checkNotNull(channelType, "channelType");
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.streamTracerFactories = Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.usingSharedBossGroup = bossGroup == null;
        this.usingSharedWorkerGroup = workerGroup == null;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionIdleInNanos = maxConnectionIdleInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        this.permitKeepAliveTimeInNanos = permitKeepAliveTimeInNanos;
    }

    @Override
    public int getPort() {
        if (this.channel == null) {
            return -1;
        }
        SocketAddress localAddr = this.channel.localAddress();
        if (!(localAddr instanceof InetSocketAddress)) {
            return -1;
        }
        return ((InetSocketAddress)localAddr).getPort();
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = Preconditions.checkNotNull(serverListener, "serverListener");
        this.allocateSharedGroups();
        ServerBootstrap b = new ServerBootstrap();
        b.group(this.bossGroup, this.workerGroup);
        b.channel(this.channelType);
        if (NioServerSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_BACKLOG, 128);
            b.childOption(ChannelOption.SO_KEEPALIVE, true);
        }
        b.childHandler(new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initChannel(Channel ch) throws Exception {
                ServerTransportListener transportListener;
                long maxConnectionAgeInNanos = NettyServer.this.maxConnectionAgeInNanos;
                if (maxConnectionAgeInNanos != Long.MAX_VALUE) {
                    maxConnectionAgeInNanos = (long)((0.9 + Math.random() * 0.2) * (double)maxConnectionAgeInNanos);
                }
                NettyServerTransport transport = new NettyServerTransport(ch, NettyServer.this.protocolNegotiator, NettyServer.this.streamTracerFactories, NettyServer.this.maxStreamsPerConnection, NettyServer.this.flowControlWindow, NettyServer.this.maxMessageSize, NettyServer.this.maxHeaderListSize, NettyServer.this.keepAliveTimeInNanos, NettyServer.this.keepAliveTimeoutInNanos, NettyServer.this.maxConnectionIdleInNanos, maxConnectionAgeInNanos, NettyServer.this.maxConnectionAgeGraceInNanos, NettyServer.this.permitKeepAliveWithoutCalls, NettyServer.this.permitKeepAliveTimeInNanos);
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    if (NettyServer.this.channel != null && !NettyServer.this.channel.isOpen()) {
                        ch.close();
                        return;
                    }
                    NettyServer.this.eventLoopReferenceCounter.retain();
                    transportListener = NettyServer.this.listener.transportCreated(transport);
                }
                transport.start(transportListener);
                ch.closeFuture().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        NettyServer.this.eventLoopReferenceCounter.release();
                    }
                });
            }
        });
        ChannelFuture future = b.bind(this.address);
        try {
            future.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for bind");
        }
        if (!future.isSuccess()) {
            throw new IOException("Failed to bind", future.cause());
        }
        this.channel = future.channel();
    }

    @Override
    public void shutdown() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        this.channel.close().addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    log.log(Level.WARNING, "Error shutting down server", future.cause());
                }
                NettyServer nettyServer = NettyServer.this;
                synchronized (nettyServer) {
                    NettyServer.this.listener.serverShutdown();
                }
                NettyServer.this.eventLoopReferenceCounter.release();
            }
        });
    }

    private void allocateSharedGroups() {
        if (this.bossGroup == null) {
            this.bossGroup = SharedResourceHolder.get(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP);
        }
        if (this.workerGroup == null) {
            this.workerGroup = SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP);
        }
    }

    class EventLoopReferenceCounter
    extends AbstractReferenceCounted {
        EventLoopReferenceCounter() {
        }

        @Override
        protected void deallocate() {
            try {
                if (NettyServer.this.usingSharedBossGroup && NettyServer.this.bossGroup != null) {
                    SharedResourceHolder.release(Utils.DEFAULT_BOSS_EVENT_LOOP_GROUP, NettyServer.this.bossGroup);
                }
            }
            finally {
                NettyServer.this.bossGroup = null;
                try {
                    if (NettyServer.this.usingSharedWorkerGroup && NettyServer.this.workerGroup != null) {
                        SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, NettyServer.this.workerGroup);
                    }
                }
                finally {
                    NettyServer.this.workerGroup = null;
                }
            }
        }

        @Override
        public ReferenceCounted touch(Object hint) {
            return this;
        }
    }
}

