/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.LogId;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.netty.ForcefulCloseCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyHandlerSettings;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerHandler;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final Channel channel;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionIdleInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final boolean permitKeepAliveWithoutCalls;
    private final long permitKeepAliveTimeInNanos;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;

    NettyServerTransport(Channel channel, ProtocolNegotiator protocolNegotiator, List<ServerStreamTracer.Factory> streamTracerFactories, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionIdleInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.protocolNegotiator = Preconditions.checkNotNull(protocolNegotiator, "protocolNegotiator");
        this.streamTracerFactories = Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionIdleInNanos = maxConnectionIdleInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        this.permitKeepAliveTimeInNanos = permitKeepAliveTimeInNanos;
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState(this.listener == null, "Handler already registered");
        this.listener = listener;
        final NettyServerHandler grpcHandler = this.createHandler(listener);
        NettyHandlerSettings.setAutoWindow(grpcHandler);
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(grpcHandler.connectionError());
            }
        });
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(grpcHandler);
        this.channel.pipeline().addLast(negotiationHandler);
    }

    @Override
    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    @Override
    public void shutdownNow(Status reason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush(new ForcefulCloseCommand(reason));
        }
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    Channel channel() {
        return this.channel;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        return NettyServerHandler.newHandler(transportListener, this.streamTracerFactories, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos);
    }
}

