/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.util;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.ConnectivityStateInfo;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class RoundRobinLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final RoundRobinLoadBalancerFactory INSTANCE = new RoundRobinLoadBalancerFactory();

    private RoundRobinLoadBalancerFactory() {
    }

    public static RoundRobinLoadBalancerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RoundRobinLoadBalancer(helper);
    }

    @VisibleForTesting
    static final class Picker
    extends LoadBalancer.SubchannelPicker {
        @Nullable
        private final Status status;
        private final List<LoadBalancer.Subchannel> list;
        private final int size;
        @GuardedBy(value="this")
        private int index = 0;

        Picker(List<LoadBalancer.Subchannel> list, @Nullable Status status) {
            this.list = Collections.unmodifiableList(list);
            this.size = list.size();
            this.status = status;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.size > 0) {
                return LoadBalancer.PickResult.withSubchannel(this.nextSubchannel());
            }
            if (this.status != null) {
                return LoadBalancer.PickResult.withError(this.status);
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LoadBalancer.Subchannel nextSubchannel() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Picker picker = this;
            synchronized (picker) {
                LoadBalancer.Subchannel val = this.list.get(this.index);
                ++this.index;
                if (this.index >= this.size) {
                    this.index = 0;
                }
                return val;
            }
        }

        @VisibleForTesting
        List<LoadBalancer.Subchannel> getList() {
            return this.list;
        }

        @VisibleForTesting
        Status getStatus() {
            return this.status;
        }
    }

    @VisibleForTesting
    static class RoundRobinLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
        @VisibleForTesting
        static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of("state-info");

        RoundRobinLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = Preconditions.checkNotNull(helper, "helper");
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            Set<EquivalentAddressGroup> currentAddrs = this.subchannels.keySet();
            Set<EquivalentAddressGroup> latestAddrs = RoundRobinLoadBalancer.stripAttrs(servers);
            Set<EquivalentAddressGroup> addedAddrs = RoundRobinLoadBalancer.setsDifference(latestAddrs, currentAddrs);
            Set<EquivalentAddressGroup> removedAddrs = RoundRobinLoadBalancer.setsDifference(currentAddrs, latestAddrs);
            for (EquivalentAddressGroup addressGroup : addedAddrs) {
                Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError(ConnectivityState.IDLE))).build();
                LoadBalancer.Subchannel subchannel = Preconditions.checkNotNull(this.helper.createSubchannel(addressGroup, subchannelAttrs), "subchannel");
                this.subchannels.put(addressGroup, subchannel);
                subchannel.requestConnection();
            }
            for (EquivalentAddressGroup addressGroup : removedAddrs) {
                LoadBalancer.Subchannel subchannel = this.subchannels.remove(addressGroup);
                subchannel.shutdown();
            }
            this.updatePicker(this.getAggregatedError());
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.updatePicker(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            if (!this.subchannels.containsValue(subchannel)) {
                return;
            }
            if (stateInfo.getState() == ConnectivityState.IDLE) {
                subchannel.requestConnection();
            }
            RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).set(stateInfo);
            this.updatePicker(this.getAggregatedError());
        }

        @Override
        public void shutdown() {
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                subchannel.shutdown();
            }
        }

        private void updatePicker(@Nullable Status error) {
            List<LoadBalancer.Subchannel> activeList = RoundRobinLoadBalancer.filterNonFailingSubchannels(this.getSubchannels());
            this.helper.updatePicker(new Picker(activeList, error));
        }

        private static List<LoadBalancer.Subchannel> filterNonFailingSubchannels(Collection<LoadBalancer.Subchannel> subchannels) {
            ArrayList<LoadBalancer.Subchannel> readySubchannels = new ArrayList<LoadBalancer.Subchannel>(subchannels.size());
            for (LoadBalancer.Subchannel subchannel : subchannels) {
                if (RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).get().getState() != ConnectivityState.READY) continue;
                readySubchannels.add(subchannel);
            }
            return readySubchannels;
        }

        private static Set<EquivalentAddressGroup> stripAttrs(List<EquivalentAddressGroup> groupList) {
            HashSet<EquivalentAddressGroup> addrs = new HashSet<EquivalentAddressGroup>();
            for (EquivalentAddressGroup group : groupList) {
                addrs.add(new EquivalentAddressGroup(group.getAddresses()));
            }
            return addrs;
        }

        @Nullable
        private Status getAggregatedError() {
            Status status = null;
            for (LoadBalancer.Subchannel subchannel : this.getSubchannels()) {
                ConnectivityStateInfo stateInfo = RoundRobinLoadBalancer.getSubchannelStateInfoRef(subchannel).get();
                if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) {
                    return null;
                }
                status = stateInfo.getStatus();
            }
            return status;
        }

        @VisibleForTesting
        Collection<LoadBalancer.Subchannel> getSubchannels() {
            return this.subchannels.values();
        }

        private static AtomicReference<ConnectivityStateInfo> getSubchannelStateInfoRef(LoadBalancer.Subchannel subchannel) {
            return Preconditions.checkNotNull(subchannel.getAttributes().get(STATE_INFO), "STATE_INFO");
        }

        private static <T> Set<T> setsDifference(Set<T> a, Set<T> b) {
            HashSet<T> aCopy = new HashSet<T>(a);
            aCopy.removeAll(b);
            return aCopy;
        }
    }
}

