/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.client.protocol;

import com.google.bigtable.repackaged.org.apache.http.Header;
import com.google.bigtable.repackaged.org.apache.http.HttpException;
import com.google.bigtable.repackaged.org.apache.http.HttpHost;
import com.google.bigtable.repackaged.org.apache.http.HttpRequest;
import com.google.bigtable.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.bigtable.repackaged.org.apache.http.ProtocolException;
import com.google.bigtable.repackaged.org.apache.http.annotation.Immutable;
import com.google.bigtable.repackaged.org.apache.http.client.CookieStore;
import com.google.bigtable.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.bigtable.repackaged.org.apache.http.client.params.HttpClientParams;
import com.google.bigtable.repackaged.org.apache.http.conn.ManagedClientConnection;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.Scheme;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.SchemeRegistry;
import com.google.bigtable.repackaged.org.apache.http.cookie.Cookie;
import com.google.bigtable.repackaged.org.apache.http.cookie.CookieOrigin;
import com.google.bigtable.repackaged.org.apache.http.cookie.CookieSpec;
import com.google.bigtable.repackaged.org.apache.http.cookie.CookieSpecRegistry;
import com.google.bigtable.repackaged.org.apache.http.cookie.SetCookie2;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        int ver;
        URI requestURI;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.info((Object)"Cookie store not available in HTTP context");
            return;
        }
        CookieSpecRegistry registry = (CookieSpecRegistry)context.getAttribute("http.cookiespec-registry");
        if (registry == null) {
            this.log.info((Object)"CookieSpec registry not available in HTTP context");
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            throw new IllegalStateException("Target host not specified in HTTP context");
        }
        ManagedClientConnection conn = (ManagedClientConnection)context.getAttribute("http.connection");
        if (conn == null) {
            throw new IllegalStateException("Client connection not specified in HTTP context");
        }
        String policy = HttpClientParams.getCookiePolicy(request.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CookieSpec selected: " + policy));
        }
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid request URI: " + request.getRequestLine().getUri(), ex);
            }
        }
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            SchemeRegistry sr = (SchemeRegistry)context.getAttribute("http.scheme-registry");
            if (sr != null) {
                Scheme scheme = sr.get(targetHost.getSchemeName());
                port = scheme.resolvePort(port);
            } else {
                port = conn.getRemotePort();
            }
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port, requestURI.getPath(), conn.isSecure());
        CookieSpec cookieSpec = registry.getCookieSpec(policy, request.getParams());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cookie " + cookie + " match " + cookieOrigin));
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Cookie " + cookie + " expired"));
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header);
            }
        }
        context.setAttribute("http.cookie-spec", cookieSpec);
        context.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

