/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.client.protocol;

import com.google.bigtable.repackaged.org.apache.http.HttpException;
import com.google.bigtable.repackaged.org.apache.http.HttpRequest;
import com.google.bigtable.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.bigtable.repackaged.org.apache.http.annotation.Immutable;
import com.google.bigtable.repackaged.org.apache.http.conn.ManagedClientConnection;
import com.google.bigtable.repackaged.org.apache.http.conn.routing.HttpRoute;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        ManagedClientConnection conn = (ManagedClientConnection)context.getAttribute("http.connection");
        if (conn == null) {
            throw new IllegalStateException("Client connection not specified in HTTP context");
        }
        HttpRoute route = conn.getRoute();
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

