/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.client.protocol;

import com.google.bigtable.repackaged.org.apache.http.HttpException;
import com.google.bigtable.repackaged.org.apache.http.HttpRequest;
import com.google.bigtable.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.bigtable.repackaged.org.apache.http.annotation.Immutable;
import com.google.bigtable.repackaged.org.apache.http.auth.AuthScheme;
import com.google.bigtable.repackaged.org.apache.http.auth.AuthState;
import com.google.bigtable.repackaged.org.apache.http.auth.AuthenticationException;
import com.google.bigtable.repackaged.org.apache.http.auth.Credentials;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RequestTargetAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block10: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT")) {
                return;
            }
            if (request.containsHeader("Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug((Object)"User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    request.addHeader(authScheme.authenticate(creds, request));
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)("Authentication error: " + ex.getMessage()));
                }
            }
        }
    }
}

