/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.impl;

import com.google.bigtable.repackaged.org.apache.http.HttpResponse;
import com.google.bigtable.repackaged.org.apache.http.HttpResponseFactory;
import com.google.bigtable.repackaged.org.apache.http.ProtocolVersion;
import com.google.bigtable.repackaged.org.apache.http.ReasonPhraseCatalog;
import com.google.bigtable.repackaged.org.apache.http.StatusLine;
import com.google.bigtable.repackaged.org.apache.http.impl.EnglishReasonPhraseCatalog;
import com.google.bigtable.repackaged.org.apache.http.message.BasicHttpResponse;
import com.google.bigtable.repackaged.org.apache.http.message.BasicStatusLine;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import java.util.Locale;

public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = catalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale loc = this.determineLocale(context);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

