/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.impl.conn;

import com.google.bigtable.repackaged.org.apache.http.HttpHost;
import com.google.bigtable.repackaged.org.apache.http.annotation.ThreadSafe;
import com.google.bigtable.repackaged.org.apache.http.conn.ClientConnectionOperator;
import com.google.bigtable.repackaged.org.apache.http.conn.HttpHostConnectException;
import com.google.bigtable.repackaged.org.apache.http.conn.OperatedClientConnection;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.LayeredSocketFactory;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.Scheme;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.SchemeRegistry;
import com.google.bigtable.repackaged.org.apache.http.conn.scheme.SocketFactory;
import com.google.bigtable.repackaged.org.apache.http.impl.conn.DefaultClientConnection;
import com.google.bigtable.repackaged.org.apache.http.params.HttpConnectionParams;
import com.google.bigtable.repackaged.org.apache.http.params.HttpParams;
import com.google.bigtable.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

@ThreadSafe
public class DefaultClientConnectionOperator
implements ClientConnectionOperator {
    protected final SchemeRegistry schemeRegistry;

    public DefaultClientConnectionOperator(SchemeRegistry schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schemes;
    }

    public OperatedClientConnection createConnection() {
        return new DefaultClientConnection();
    }

    public void openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (conn.isOpen()) {
            throw new IllegalArgumentException("Connection must not be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        SocketFactory sf = schm.getSocketFactory();
        Socket sock = sf.createSocket();
        conn.opening(sock, target);
        try {
            sock = sf.connectSocket(sock, target.getHostName(), schm.resolvePort(target.getPort()), local, 0, params);
        }
        catch (ConnectException ex) {
            throw new HttpHostConnectException(target, ex);
        }
        this.prepareSocket(sock, context, params);
        conn.openCompleted(sf.isSecure(sock), params);
    }

    public void updateSecureConnection(OperatedClientConnection conn, HttpHost target, HttpContext context, HttpParams params) throws IOException {
        Socket sock;
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (!conn.isOpen()) {
            throw new IllegalArgumentException("Connection must be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        if (!(schm.getSocketFactory() instanceof LayeredSocketFactory)) {
            throw new IllegalArgumentException("Target scheme (" + schm.getName() + ") must have layered socket factory.");
        }
        LayeredSocketFactory lsf = (LayeredSocketFactory)schm.getSocketFactory();
        try {
            sock = lsf.createSocket(conn.getSocket(), target.getHostName(), target.getPort(), true);
        }
        catch (ConnectException ex) {
            throw new HttpHostConnectException(target, ex);
        }
        this.prepareSocket(sock, context, params);
        conn.update(sock, target, lsf.isSecure(sock), params);
    }

    protected void prepareSocket(Socket sock, HttpContext context, HttpParams params) throws IOException {
        sock.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        sock.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            sock.setSoLinger(linger > 0, linger);
        }
    }
}

