/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.org.apache.http.impl.io;

import com.google.bigtable.repackaged.org.apache.http.Header;
import com.google.bigtable.repackaged.org.apache.http.HeaderIterator;
import com.google.bigtable.repackaged.org.apache.http.HttpException;
import com.google.bigtable.repackaged.org.apache.http.HttpMessage;
import com.google.bigtable.repackaged.org.apache.http.io.HttpMessageWriter;
import com.google.bigtable.repackaged.org.apache.http.io.SessionOutputBuffer;
import com.google.bigtable.repackaged.org.apache.http.message.BasicLineFormatter;
import com.google.bigtable.repackaged.org.apache.http.message.LineFormatter;
import com.google.bigtable.repackaged.org.apache.http.params.HttpParams;
import com.google.bigtable.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public abstract class AbstractMessageWriter
implements HttpMessageWriter {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.DEFAULT;
    }

    protected abstract void writeHeadLine(HttpMessage var1) throws IOException;

    public void write(HttpMessage message) throws IOException, HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

