/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;

public class BigtableBufferedMutator
implements BufferedMutator {
    protected static final Logger LOG = new Logger(BigtableBufferedMutator.class);
    private final Configuration configuration;
    private final ReentrantReadWriteLock isClosedLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock closedReadLock = this.isClosedLock.readLock();
    private final ReentrantReadWriteLock.WriteLock closedWriteLock = this.isClosedLock.writeLock();
    private boolean closed = false;
    private final HBaseRequestAdapter adapter;
    private final BufferedMutator.ExceptionListener exceptionListener;
    private final AtomicBoolean hasExceptions = new AtomicBoolean(false);
    private final List<MutationException> globalExceptions = new ArrayList<MutationException>();
    private final String host;
    private final AsyncExecutor asyncExecutor;
    private BulkMutation bulkMutation = null;
    private BigtableOptions options;

    public BigtableBufferedMutator(HBaseRequestAdapter adapter, Configuration configuration, BigtableSession session, BufferedMutator.ExceptionListener listener) {
        this.adapter = adapter;
        this.configuration = configuration;
        this.exceptionListener = listener;
        this.options = session.getOptions();
        this.host = this.options.getDataHost().toString();
        this.asyncExecutor = session.createAsyncExecutor();
        BigtableTableName tableName = this.adapter.getBigtableTableName();
        this.bulkMutation = session.createBulkMutation(tableName);
    }

    public void close() throws IOException {
        this.closedWriteLock.lock();
        try {
            this.flush();
            this.asyncExecutor.flush();
            this.closed = true;
        }
        finally {
            this.closedWriteLock.unlock();
        }
    }

    public void flush() throws IOException {
        if (this.bulkMutation != null) {
            try {
                this.bulkMutation.flush();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("flush() was interrupted", e);
            }
        }
        this.asyncExecutor.flush();
        this.handleExceptions();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TableName getName() {
        return this.adapter.getTableName();
    }

    public long getWriteBufferSize() {
        return this.options.getBulkOptions().getMaxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(List<? extends Mutation> mutations) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            for (Mutation mutation : mutations) {
                this.offer(mutation);
            }
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    public void mutate(Mutation mutation) throws IOException {
        this.closedReadLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Cannot mutate when the BufferedMutator is closed.");
            }
            this.handleExceptions();
            this.offer(mutation);
        }
        finally {
            this.closedReadLock.unlock();
        }
    }

    private void offer(Mutation mutation) {
        ListenableFuture<Object> future = null;
        try {
            future = mutation == null ? Futures.immediateFailedFuture(new IllegalArgumentException("Cannot perform a mutation on a null object.")) : (mutation instanceof Put ? this.bulkMutation.add(this.adapter.adaptEntry((Put)mutation)) : (mutation instanceof Delete ? this.bulkMutation.add(this.adapter.adaptEntry((Delete)mutation)) : (mutation instanceof Increment ? this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Increment)mutation)) : (mutation instanceof Append ? this.asyncExecutor.readModifyWriteRowAsync(this.adapter.adapt((Append)mutation)) : Futures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown mutation type: " + mutation.getClass()))))));
        }
        catch (Exception e) {
            future = Futures.immediateFailedFuture(e);
        }
        Futures.addCallback(future, new ExceptionCallback((Row)mutation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalException(Row mutation, Throwable t) {
        List<MutationException> list = this.globalExceptions;
        synchronized (list) {
            this.globalExceptions.add(new MutationException(mutation, t));
            this.hasExceptions.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptions() throws RetriesExhaustedWithDetailsException {
        if (this.hasExceptions.get()) {
            ArrayList<MutationException> mutationExceptions = null;
            List<MutationException> list = this.globalExceptions;
            synchronized (list) {
                this.hasExceptions.set(false);
                if (this.globalExceptions.isEmpty()) {
                    return;
                }
                mutationExceptions = new ArrayList<MutationException>(this.globalExceptions);
                this.globalExceptions.clear();
            }
            ArrayList<Throwable> problems = new ArrayList<Throwable>(mutationExceptions.size());
            ArrayList<String> hostnames = new ArrayList<String>(mutationExceptions.size());
            ArrayList<Row> failedMutations = new ArrayList<Row>(mutationExceptions.size());
            for (MutationException mutationException : mutationExceptions) {
                problems.add(mutationException.throwable);
                failedMutations.add(mutationException.mutation);
                hostnames.add(this.host);
            }
            RetriesExhaustedWithDetailsException exception = new RetriesExhaustedWithDetailsException(problems, failedMutations, hostnames);
            this.exceptionListener.onException(exception, (BufferedMutator)this);
        }
    }

    public boolean hasInflightRequests() {
        return this.asyncExecutor.hasInflightRequests() || this.bulkMutation != null && !this.bulkMutation.isFlushed();
    }

    private class ExceptionCallback
    implements FutureCallback {
        private final Row mutation;

        public ExceptionCallback(Row mutation) {
            this.mutation = mutation;
        }

        @Override
        public void onFailure(Throwable t) {
            BigtableBufferedMutator.this.addGlobalException(this.mutation, t);
        }

        public void onSuccess(Object ignored) {
        }
    }

    private static class MutationException {
        private final Row mutation;
        private final Throwable throwable;

        MutationException(Row mutation, Throwable throwable) {
            this.mutation = mutation;
            this.throwable = throwable;
        }
    }
}

