/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;

public class BigtableConfiguration {
    private static final String[] CONNECTION_CLASS_NAMES = new String[]{"com.google.cloud.bigtable.hbase1_0.BigtableConnection", "com.google.cloud.bigtable.hbase1_1.BigtableConnection", "com.google.cloud.bigtable.hbase1_2.BigtableConnection", "com.google.cloud.bigtable.hbase1_3.BigtableConnection", "com.google.cloud.bigtable.hbase1_x.BigtableConnection"};
    private static final Class<? extends Connection> CONNECTION_CLASS = BigtableConfiguration.chooseConnectionClass();

    private static Class<? extends Connection> chooseConnectionClass() {
        for (String className : CONNECTION_CLASS_NAMES) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static Class<? extends Connection> getConnectionClass() {
        Preconditions.checkState(CONNECTION_CLASS != null, "Could not load a concrete implementation of BigtableTableConnection: failed to find bigtable-hbase-1.x on the classpath.");
        return CONNECTION_CLASS;
    }

    public static Configuration configure(String projectId, String instanceId) {
        Configuration config = new Configuration(false);
        return BigtableConfiguration.configure(config, projectId, instanceId);
    }

    public static Configuration configure(Configuration conf, String projectId, String instanceId) {
        conf.set("google.bigtable.project.id", projectId);
        conf.set("google.bigtable.instance.id", instanceId);
        conf.set("hbase.client.connection.impl", BigtableConfiguration.getConnectionClass().getCanonicalName());
        return conf;
    }

    public static Connection connect(String projectId, String instanceId) {
        return BigtableConfiguration.connect(BigtableConfiguration.configure(projectId, instanceId));
    }

    public static Connection connect(Configuration conf) {
        Class<? extends Connection> connectionClass = BigtableConfiguration.getConnectionClass();
        try {
            return connectionClass.getConstructor(Configuration.class).newInstance(conf);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find an appropriate constructor for " + CONNECTION_CLASS.getCanonicalName(), e);
        }
    }
}

