/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class BigtableRegionLocator
implements RegionLocator {
    public static long MAX_REGION_AGE_MILLIS = 60000L;
    protected static final Logger LOG = new Logger(BigtableRegionLocator.class);
    private final TableName tableName;
    private final BigtableDataClient client;
    private final SampledRowKeysAdapter adapter;
    private final BigtableTableName bigtableTableName;
    private List<HRegionLocation> regions;
    private long regionsFetchTimeMillis;

    public BigtableRegionLocator(TableName tableName, BigtableOptions options, BigtableDataClient client) {
        this.tableName = tableName;
        this.client = client;
        this.bigtableTableName = options.getInstanceName().toTableName(tableName.getNameAsString());
        ServerName serverName = ServerName.valueOf((String)options.getDataHost(), (int)options.getPort(), (long)0L);
        this.adapter = new SampledRowKeysAdapter(tableName, serverName);
    }

    private synchronized List<HRegionLocation> getRegions(boolean reload) throws IOException {
        if (!reload && this.regions != null && this.regionsFetchTimeMillis + MAX_REGION_AGE_MILLIS > System.currentTimeMillis()) {
            return this.regions;
        }
        SampleRowKeysRequest.Builder request = SampleRowKeysRequest.newBuilder();
        request.setTableName(this.bigtableTableName.toString());
        LOG.debug("Sampling rowkeys for table %s", request.getTableName());
        try {
            List<SampleRowKeysResponse> responses = this.client.sampleRowKeys(request.build());
            this.regions = this.adapter.adaptResponse(responses);
            this.regionsFetchTimeMillis = System.currentTimeMillis();
            return this.regions;
        }
        catch (Throwable throwable) {
            this.regions = null;
            throw new IOException("Error sampling rowkeys.", throwable);
        }
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.getRegionLocation(row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        for (HRegionLocation region : this.getRegions(reload)) {
            if (!region.getRegionInfo().containsRow(row)) continue;
            return region;
        }
        throw new IOException("Region not found for row: " + Bytes.toStringBinary((byte[])row));
    }

    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        return this.getRegions(false);
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List<HRegionLocation> regions = this.getAllRegionLocations();
        byte[][] startKeys = new byte[regions.size()][];
        byte[][] endKeys = new byte[regions.size()][];
        int i = 0;
        for (HRegionLocation region : regions) {
            startKeys[i] = region.getRegionInfo().getStartKey();
            endKeys[i] = region.getRegionInfo().getEndKey();
            ++i;
        }
        return Pair.newPair((Object)startKeys, (Object)endKeys);
    }

    public TableName getName() {
        return this.tableName;
    }

    public void close() throws IOException {
    }
}

