/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.client.util.Clock;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Put;

public class PutAdapter
extends MutationAdapter<Put> {
    private final int maxKeyValueSize;
    private final boolean setClientTimestamp;
    @VisibleForTesting
    Clock clock = Clock.SYSTEM;

    public PutAdapter(int maxKeyValueSize) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = true;
    }

    public PutAdapter(int maxKeyValueSize, boolean setClientTimestamp) {
        this.maxKeyValueSize = maxKeyValueSize;
        this.setClientTimestamp = setClientTimestamp;
    }

    @Override
    protected Collection<Mutation> adaptMutations(Put operation) {
        if (operation.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        long currentTimestampMicros = this.setClientTimestamp ? this.clock.currentTimeMillis() * 1000L : -1L;
        int rowLength = operation.getRow().length;
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(operation.size());
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            ByteString familyString = ByteString.copyFrom((byte[])entry.getKey());
            int familySize = familyString.size();
            for (Cell cell : (List)entry.getValue()) {
                int qualifierLength = cell.getQualifierLength();
                int valueLength = cell.getValueLength();
                int keyValueSize = 20 + rowLength + familySize + qualifierLength + valueLength;
                if (this.maxKeyValueSize > 0 && keyValueSize > this.maxKeyValueSize) {
                    throw new IllegalArgumentException("KeyValue size too large");
                }
                ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), qualifierLength);
                ByteString value = ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), valueLength);
                long timestampMicros = currentTimestampMicros;
                if (cell.getTimestamp() != Long.MAX_VALUE) {
                    timestampMicros = TimestampConverter.hbase2bigtable(cell.getTimestamp());
                }
                mutations.add(Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyNameBytes(familyString).setColumnQualifier(cellQualifierByteString).setValue(value).setTimestampMicros(timestampMicros)).build());
            }
        }
        return mutations;
    }

    @Override
    public Put adapt(MutateRowRequest request) throws IOException {
        if (request.getMutationsCount() == 0) {
            throw new IllegalArgumentException("No columns to insert");
        }
        byte[] rowkeyArray = request.getRowKey().toByteArray();
        Put put = new Put(rowkeyArray);
        for (Mutation mutation : request.getMutationsList()) {
            if (mutation.getMutationCase() != Mutation.MutationCase.SET_CELL) {
                throw new IllegalArgumentException("Cannot process mutation of type: " + mutation.getMutationCase());
            }
            Mutation.SetCell setCell = mutation.getSetCell();
            long timestampHbase = setCell.getTimestampMicros() == -1L ? Long.MAX_VALUE : BigtableConstants.HBASE_TIMEUNIT.convert(setCell.getTimestampMicros(), BigtableConstants.BIGTABLE_TIMEUNIT);
            put.add((Cell)new RowCell(rowkeyArray, PutAdapter.getBytes(setCell.getFamilyNameBytes()), PutAdapter.getBytes(setCell.getColumnQualifier()), timestampHbase, PutAdapter.getBytes(setCell.getValue())));
        }
        return put;
    }
}

