/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;

public class BigtableWhileMatchResultScannerAdapter {
    private static final String WHILE_MATCH_FILTER_IN_LABEL_SUFFIX = "-in";
    private static final String WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX = "-out";
    final ResponseAdapter<FlatRow, Result> rowAdapter;

    public BigtableWhileMatchResultScannerAdapter(ResponseAdapter<FlatRow, Result> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public org.apache.hadoop.hbase.client.ResultScanner adapt(final ResultScanner<FlatRow> bigtableResultScanner) {
        return new AbstractClientScanner(){

            public Result next() throws IOException {
                FlatRow row = (FlatRow)bigtableResultScanner.next();
                if (row == null) {
                    return null;
                }
                if (!BigtableWhileMatchResultScannerAdapter.hasMatchingLabels(row)) {
                    return null;
                }
                return BigtableWhileMatchResultScannerAdapter.this.rowAdapter.adaptResponse(row);
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (IOException ioe) {
                    throw Throwables.propagate(ioe);
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }

    private static boolean hasMatchingLabels(FlatRow row) {
        int inLabelCount = 0;
        int outLabelCount = 0;
        for (FlatRow.Cell cell : row.getCells()) {
            for (String label : cell.getLabels()) {
                if (label.endsWith(WHILE_MATCH_FILTER_IN_LABEL_SUFFIX)) {
                    ++inLabelCount;
                    continue;
                }
                if (!label.endsWith(WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX)) continue;
                ++outLabelCount;
            }
        }
        return inLabelCount == outLabelCount;
    }
}

