/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.util.Pair;

public class FuzzyRowFilterAdapter
extends TypedFilterAdapterBase<FuzzyRowFilter> {
    private static final RowFilter ALL_VALUES_FILTER = RowFilter.newBuilder().setCellsPerColumnLimitFilter(Integer.MAX_VALUE).build();
    private static Field FUZZY_KEY_DATA_FIELD;
    private static Exception FUZZY_KEY_DATA_FIELD_EXCEPTION;

    @Override
    public RowFilter adapt(FilterAdapterContext context, FuzzyRowFilter filter) throws IOException {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        List<Pair<byte[], byte[]>> pairs = FuzzyRowFilterAdapter.extractFuzzyRowFilterPairs(filter);
        if (pairs.isEmpty()) {
            return ALL_VALUES_FILTER;
        }
        for (Pair<byte[], byte[]> pair : pairs) {
            Preconditions.checkArgument(((byte[])pair.getFirst()).length == ((byte[])pair.getSecond()).length, "Fuzzy info and match mask must have the same length");
            interleaveBuilder.addFilters(FuzzyRowFilterAdapter.createSingleRowFilter((byte[])pair.getFirst(), (byte[])pair.getSecond()));
        }
        if (interleaveBuilder.getFiltersCount() == 1) {
            return interleaveBuilder.getFilters(0);
        }
        return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
    }

    private static RowFilter createSingleRowFilter(byte[] key, byte[] mask) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(key.length * 2);
        ReaderExpressionHelper.QuoteMetaOutputStream quotingStream = new ReaderExpressionHelper.QuoteMetaOutputStream(baos);
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1) {
                quotingStream.write(key[i]);
                continue;
            }
            baos.write(ReaderExpressionHelper.ANY_BYTE_BYTES);
        }
        ByteString quotedValue = ByteStringer.wrap(baos.toByteArray());
        quotingStream.close();
        return RowFilter.newBuilder().setRowKeyRegexFilter(quotedValue).build();
    }

    static List<Pair<byte[], byte[]>> extractFuzzyRowFilterPairs(FuzzyRowFilter filter) throws IOException {
        if (FUZZY_KEY_DATA_FIELD_EXCEPTION != null) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter");
        }
        try {
            return (List)FUZZY_KEY_DATA_FIELD.get(filter);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException("Could not read the contents of the FuzzyRowFilter", e);
        }
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, FuzzyRowFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    static {
        try {
            FUZZY_KEY_DATA_FIELD = FuzzyRowFilter.class.getDeclaredField("fuzzyKeysData");
            FUZZY_KEY_DATA_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            FUZZY_KEY_DATA_FIELD_EXCEPTION = e;
        }
    }
}

