/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TimestampRange;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.util.Iterator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;

public class TimestampsFilterAdapter
extends TypedFilterAdapterBase<TimestampsFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, TimestampsFilter filter) {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        Iterator iterator = filter.getTimestamps().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            long bigtableStartTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(timestamp, BigtableConstants.HBASE_TIMEUNIT);
            long bigtableEndTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(timestamp + 1L, BigtableConstants.HBASE_TIMEUNIT);
            interleaveBuilder.addFilters(RowFilter.newBuilder().setTimestampRangeFilter(TimestampRange.newBuilder().setStartTimestampMicros(bigtableStartTimestamp).setEndTimestampMicros(bigtableEndTimestamp)));
        }
        return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, TimestampsFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }
}

